package cn.majingjing.core.util;


import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

/**
 * Security Utils
 *
 * @author majinding888@foxmail.com
 * @date 2016-8-26 下午1:34:13
 */
public class SecurityUtils {

    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_SHA1 = "sha1";
    private static final String ALGORITHM_MD5 = "md5";
    private static final String MAC_NAME = "HmacSHA1";
    private static final String ENCODING = "UTF-8";

    public static class HmacSHA1 {

        public static String encode(String key,String content) {
            try {
                byte[] data = key.getBytes(ENCODING);
                SecretKey secretKey = new SecretKeySpec(data, MAC_NAME);
                Mac mac = Mac.getInstance(MAC_NAME);
                mac.init(secretKey);

                byte[] text = content.getBytes(ENCODING);
                byte[] rest =  mac.doFinal(text);
                return new String(rest, ENCODING);
            } catch (Exception e) {
                throw new SecurityException(e);
            }
        }

    }

    public static class Sha1 {
        public static String encode(String content) {
            try {
                return digest(ALGORITHM_SHA1, content);
            } catch (Exception e) {
                throw new SecurityException(e);
            }
        }
    }


    public static class Md5 {
        public static String encode(String content) {
            try {
                return digest(ALGORITHM_MD5, content);
            } catch (Exception e) {
                throw new SecurityException(e);
            }
        }
    }

    public static class Aes {
        /**
         * aes encode
         * @param key key string
         * @param content text
         * @return String
         */
        public static String encode(String key, String content) {
            try {
                SecretKey secretKey = aesSecretKey(key);
                Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
                cipher.init(Cipher.ENCRYPT_MODE, secretKey);
                byte[] byteEncode = content.getBytes(StandardCharsets.UTF_8);
                byte[] byteAes = cipher.doFinal(byteEncode);
                return Base64.getEncoder().encodeToString(byteAes);
            } catch (Exception e) {
                throw new SecurityException(e);
            }
        }


        /**
         * aes decode
         * @param key key string
         * @param content text
         * @return String
         */
        public static String decode(String key, String content) {
            try {
                SecretKey secretKey = aesSecretKey(key);
                Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
                cipher.init(Cipher.DECRYPT_MODE, secretKey);
                byte[] byteContent = Base64.getDecoder().decode(content);
                byte[] byteDecode = cipher.doFinal(byteContent);
                return new String(byteDecode, ENCODING);
            } catch (Exception e) {
                throw new SecurityException(e);
            }
        }


        /**
         * Generator secret key
         * @param key key string
         * @return SecretKey
         * @throws NoSuchAlgorithmException algorithm error
         */
        private static SecretKey aesSecretKey(String key) throws NoSuchAlgorithmException {
            KeyGenerator keygen = KeyGenerator.getInstance(ALGORITHM_AES);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes());
            keygen.init(128, secureRandom);
            byte[] raw = keygen.generateKey().getEncoded();
            return new SecretKeySpec(raw, ALGORITHM_AES);
        }
    }




    /**
     * digest the str with algorithm
     * @param algorithm algorithm
     * @param str text
     * @return string
     */
    private static String digest(String algorithm, String str) {
        try {
            StringBuilder sb = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(str.getBytes());
            byte[] msg = md.digest();
            for (byte b : msg) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        } catch (NoSuchAlgorithmException e) {
            return null;
        }

    }
}

