package cn.majingjing.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

/**
 * Reflect Utils
 *
 * @author majinding888@foxmail.com
 * @date 2016-11-2 下午5:02:47
 */
public class ReflectUtils {

    @SuppressWarnings("unchecked")
    public static <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        return (Class<T>) Thread.currentThread().getContextClassLoader().loadClass(name);
    }


    @SafeVarargs
    public static Set<Method> getMethods(Class<?> clz, Class<? extends Annotation>... fieldAnnotations) {
        Method[] methods = clz.getDeclaredMethods();
        Set<Method> mst = new HashSet<>();
        for (Method method : methods) {
            if (isAnnotationPresent(method, fieldAnnotations)) {
                mst.add(method);
            }
        }
        return mst;
    }

    @SafeVarargs
    public static Set<Field> getFields(Class<?> clz, Class<? extends Annotation>... fieldAnnotations) {
        Field[] fields = clz.getDeclaredFields();
        Set<Field> fset = new HashSet<>();
        for (Field field : fields) {
            if (isAnnotationPresent(field, fieldAnnotations)) {
                fset.add(field);
            }
        }
        return fset;
    }

    /**
     * Get all fields of class declare , extends super-class fields
     * @param clz clz
     * @param fieldAnnotations field annotation
     * @return field set
     */
    @SafeVarargs
    public static Set<Field> getAllFields(Class<?> clz, Class<? extends Annotation>... fieldAnnotations) {
        Set<Field> fset = new HashSet<>();
        do {
            fset.addAll(ReflectUtils.getFields(clz, fieldAnnotations));
            clz = clz.getSuperclass();
        } while (clz != Object.class);
        return fset;
    }

    @SafeVarargs
    public static boolean isAnnotationPresent(Class<?> clz, Class<? extends Annotation>... fieldAnnotions) {
        for (Class<? extends Annotation> fieldAnnotation : fieldAnnotions) {
            if (!clz.isAnnotationPresent(fieldAnnotation)) {
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation>... fieldAnnotions) {
        for (Class<? extends Annotation> fieldAnnotation : fieldAnnotions) {
            if (!method.isAnnotationPresent(fieldAnnotation)) {
                return false;
            }
        }
        return true;
    }

    @SafeVarargs
    public static boolean isAnnotationPresent(Field field, Class<? extends Annotation>... fieldAnnotions) {
        for (Class<? extends Annotation> fieldAnnotation : fieldAnnotions) {
            if (!field.isAnnotationPresent(fieldAnnotation)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 获取Method (会修改访问级别为public)
     * @param clazz 类
     * @param methodName 方法名称
     * @param paramTypes 参数类型
     * @return 方法对象
     * @throws NoSuchMethodException 找不到方法异常
     */
    public static Method findMethod(Class<?> clazz, String methodName, Class<?>... paramTypes) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(methodName, paramTypes);
        if(!method.isAccessible()){
            method.setAccessible(true);
        }
        return method;
    }

}
