package cn.majingjing.core.util;

import java.io.*;

/**
 * Object Utils
 *
 * @author JingjingMa
 * @date 2019/11/14 20:38
 */
public class ObjectUtils {

    /**
     * Clone object
     * @param source object to be cloned
     * @param <T> the object type
     * @return  the target object of cloned
     * @throws IOException maybe throw IOException
     */
    @SuppressWarnings("unckecked")
    public static <T extends Serializable> T clone(T source) throws IOException {
        T result;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(source);
        oos.flush();
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()))) {
            return result = (T) ois.readObject();
        } catch (Exception e) {
            throw new IOException(e);
        }
    }

    /**
     * Serialize objects into byte []
     * @param obj object to be serialized
     * @return byte array
     * @throws IOException maybe throw IOException
     */
    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos)) {
            oos.writeObject(obj);
            oos.flush();
        }
        return bos.toByteArray();
    }

    /**
     * Deserialize byte [] into object
     *
     * @param bytes byte array
     * @param <T>   de-serialized object type
     * @return object with declare type T
     * @throws IOException maybe throw IOException
     */
    public static <T> T deserialize(byte[] bytes) throws IOException {
        try {
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes))) {
                return (T) ois.readObject();
            }
        } catch (Exception e) {
            throw new IOException(e);
        }
    }
}
