package cn.majingjing.core.util;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Date Utils
 *
 * @author JingjingMa
 * @date 2020-04-14
 */
public class DateUtils {

    /**
     * China zone-id
     */
    public static final ZoneId CHINA_ZONE_ID = ZoneId.of("Asia/Shanghai");

    /**
     * Get a timestamp
     *
     * @return long
     */
    public static long timestamp() {
        return Instant.now().toEpochMilli();
    }

    /**
     * Get now date
     *
     * @return Date
     */
    public static Date nowDate() {
        return Calendar.getInstance(Locale.CHINA).getTime();
    }

    /**
     * Get now date-time
     *
     * @return LocalDateTime
     */
    public static LocalDateTime now() {
        return LocalDateTime.now(CHINA_ZONE_ID);
    }

    /**
     * Covert a timestamp to local-date-time object
     *
     * @param timestamp a timestamp
     * @return LocalDateTime
     */
    public static LocalDateTime toDateTime(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, CHINA_ZONE_ID);
    }


    /**
     * 计算两个时间相差的秒数
     * @param dateTimeA 时间A
     * @param dateTimeB 时间B
     * @return long 相差的秒数
     */
    public static long differentSeconds(LocalDateTime dateTimeA, LocalDateTime dateTimeB) {
        long secondA = dateTimeA.toEpochSecond(ZoneOffset.UTC);
        long secondB = dateTimeB.toEpochSecond(ZoneOffset.UTC);

        long differentSecond = secondA - secondB;
        return Math.abs(differentSecond);
    }


}
