package cn.majingjing.core.foundation;

import cn.majingjing.core.annotation.Since;

/**
 * @author MaMarion
 */
@Since("3.0.0")
public class MyInjector {

  private static volatile Injector s_injector;
  private static final Object LOCK = new Object();

  private static Injector getInjector() {
    if (s_injector == null) {
      synchronized (LOCK) {
        if (s_injector == null) {
          try {
            s_injector = ServiceBootstrap.loadFirst(Injector.class);
          } catch (Throwable ex) {
            throw new IllegalStateException("Unable to initialize MyInjector!", ex);
          }
        }
      }
    }

    return s_injector;
  }

  public static <T> T getInstance(Class<T> clazz) {
    try {
      return getInjector().getInstance(clazz);
    } catch (Throwable ex) {
      throw new IllegalStateException(String.format("Unable to load instance for type %s!", clazz.getName()), ex);
    }
  }

  public static <T> T getInstance(Class<T> clazz, String name) {
    try {
      return getInjector().getInstance(clazz, name);
    } catch (Throwable ex) {
      throw new IllegalStateException(
              String.format("Unable to load instance for type %s and name %s !", clazz.getName(), name), ex);
    }
  }

}