package cn.majingjing.core.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import static java.lang.annotation.ElementType.*;


/**
 * @author MaMarion
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(value={CONSTRUCTOR, FIELD, LOCAL_VARIABLE, METHOD, PACKAGE, PARAMETER, TYPE})
public @interface Since {
    /**
     * version
     * @return String
     */
    String value() default "";
    /**
     * version
     * @return String
     */
    String version() default "";

    /**
     * change type
     * @return Change
     */
    Change change() default Change.Add;
}