/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx.jackson;

import cn.maarlakes.enumx.EnumFlags;
import cn.maarlakes.enumx.EnumValue;
import cn.maarlakes.enumx.jackson.EnumValueDeserializer;
import cn.maarlakes.enumx.jackson.FlagsValueDeserializer;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.type.ReferenceType;

class ValueDeserializers
extends SimpleDeserializers {
    ValueDeserializers() {
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (type.isEnum() && EnumValue.class.isAssignableFrom(type)) {
            return new EnumValueDeserializer(type);
        }
        return super.findEnumDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class rawType = type.getRawClass();
        if (EnumFlags.class.isAssignableFrom(rawType)) {
            return new FlagsValueDeserializer(rawType);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        Class rawType = refType.getContentType().getRawClass();
        if (rawType.isEnum() && EnumValue.class.isAssignableFrom(rawType)) {
            return new EnumValueDeserializer(rawType);
        }
        if (EnumFlags.class.isAssignableFrom(rawType)) {
            return new FlagsValueDeserializer(rawType);
        }
        return super.findReferenceDeserializer(refType, config, beanDesc, contentTypeDeserializer, contentDeserializer);
    }

    public boolean hasDeserializerFor(DeserializationConfig config, Class<?> valueType) {
        return valueType.isEnum() && EnumValue.class.isAssignableFrom(valueType) || EnumFlags.class.isAssignableFrom(valueType) || super.hasDeserializerFor(config, valueType);
    }
}

