/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx.jackson;

import cn.maarlakes.enumx.EnumValue;
import cn.maarlakes.enumx.Enums;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import jakarta.annotation.Nonnull;
import java.io.IOException;

public class EnumValueKeyDeserializer<E extends Enum<E>, V>
extends KeyDeserializer {
    private final Class<E> enumType;
    private final Class<V> enumValueType;

    public EnumValueKeyDeserializer(@Nonnull Class<?> enumType) {
        if (!enumType.isEnum() || !EnumValue.class.isAssignableFrom(enumType)) {
            throw new IllegalArgumentException();
        }
        this.enumType = enumType;
        this.enumValueType = Enums.getValueType(enumType);
    }

    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        if (key == null) {
            return null;
        }
        String newKey = key.trim();
        if (newKey.isEmpty()) {
            return key;
        }
        return Enums.valueOf(this.enumType, this.enumValueType, newKey, true);
    }
}

