/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx.jackson;

import cn.maarlakes.enumx.EnumValue;
import cn.maarlakes.enumx.Enums;
import cn.maarlakes.enumx.jackson.BaseValueDeserializer;
import jakarta.annotation.Nonnull;

public class EnumValueDeserializer<E extends Enum<E>, V>
extends BaseValueDeserializer<E, V> {
    private final Class<E> enumType;

    public EnumValueDeserializer(Class<?> enumType) {
        super(Enums.getValueType(enumType));
        if (!enumType.isEnum() || !EnumValue.class.isAssignableFrom(enumType)) {
            throw new IllegalArgumentException();
        }
        this.enumType = enumType;
    }

    @Override
    protected E deserializer(@Nonnull Object value) {
        return Enums.valueOf(this.enumType, this.valueType, value, true);
    }
}

