/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx.jackson;

import cn.maarlakes.enumx.Valuable;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import jakarta.annotation.Nonnull;
import java.io.IOException;

abstract class BaseValueDeserializer<T extends Valuable<V>, V>
extends StdDeserializer<T> {
    protected final Class<V> valueType;

    protected BaseValueDeserializer(Class<?> valueType) {
        super(valueType);
        if (Valuable.class.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException();
        }
        this.valueType = valueType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (Number.class.isAssignableFrom(this.valueType)) {
            Number number = p.getNumberValue();
            if (number == null) {
                return null;
            }
            return this.deserializer(this.convertValue(number));
        }
        String text = p.getText();
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        return this.deserializer(text);
    }

    protected abstract T deserializer(@Nonnull Object var1);

    private Object convertValue(@Nonnull Number number) {
        if (Integer.class.isAssignableFrom(this.valueType)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(this.valueType)) {
            return number.longValue();
        }
        if (Short.class.isAssignableFrom(this.valueType)) {
            return number.shortValue();
        }
        if (Byte.class.isAssignableFrom(this.valueType)) {
            return number.byteValue();
        }
        if (Float.class.isAssignableFrom(this.valueType)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(this.valueType)) {
            return number.doubleValue();
        }
        return number;
    }
}

