/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.Valuable;
import jakarta.annotation.Nonnull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class ValueUtils {
    private static final ConcurrentMap<Class<?>, Class<?>> VALUE_TYPES = new ConcurrentHashMap();

    private ValueUtils() {
    }

    static <T extends Valuable<V>, V> Class<V> getValueType(@Nonnull Class<T> type) {
        if (!Valuable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type not is Valuable.");
        }
        return VALUE_TYPES.computeIfAbsent(type, key -> {
            Type valueType = ValueUtils.getValueTypeArgument(ValueUtils.getParentType(type));
            if (!(valueType instanceof Class)) {
                throw new IllegalStateException();
            }
            return (Class)valueType;
        });
    }

    private static Type getParentType(Class<?> type) {
        Type[] genericInterfaces;
        for (Type item : genericInterfaces = type.getGenericInterfaces()) {
            Class midClass;
            if (item instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)item).getRawType();
                if (!(rawType instanceof Class)) {
                    throw new IllegalStateException("");
                }
                midClass = (Class)rawType;
            } else if (item instanceof Class) {
                midClass = (Class)item;
            } else {
                throw new IllegalStateException();
            }
            if (!Valuable.class.isAssignableFrom(midClass)) continue;
            return item;
        }
        return type.getGenericSuperclass();
    }

    private static Type getValueTypeArgument(Type type) {
        if (type instanceof Class) {
            return ValueUtils.getValueTypeArgument((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return ValueUtils.getValueTypeArgument((ParameterizedType)type);
        }
        return null;
    }

    private static Type getValueTypeArgument(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("");
        }
        if (rawType == Valuable.class) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        if (!Valuable.class.isAssignableFrom((Class)rawType)) {
            return null;
        }
        Type valueTypeArgument = ValueUtils.getValueTypeArgument(rawType);
        if (valueTypeArgument instanceof ParameterizedType) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        if (valueTypeArgument instanceof TypeVariable) {
            return ValueUtils.getValueTypeArgument(parameterizedType, (TypeVariable)valueTypeArgument);
        }
        if (valueTypeArgument instanceof Class) {
            return valueTypeArgument;
        }
        return null;
    }

    private static Type getValueTypeArgument(ParameterizedType parameterizedType, TypeVariable<?> typeVariable) {
        Class rawType = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (typeParameters[i] != typeVariable) continue;
            return parameterizedType.getActualTypeArguments()[i];
        }
        return null;
    }

    private static Type getValueTypeArgument(Class<?> type) {
        if (!Valuable.class.isAssignableFrom(type)) {
            return null;
        }
        return ValueUtils.getValueTypeArgument(ValueUtils.getParentType(type));
    }
}

