/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.EnumFlags;
import cn.maarlakes.enumx.Flags;
import cn.maarlakes.enumx.Valuable;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class LongFlags<F extends LongFlags<F, E>, E extends Enum<E>>
implements EnumFlags<F, E, Long> {
    @Override
    public boolean contains(Long flagValue) {
        if (flagValue == null) {
            return false;
        }
        return Objects.equals((Long)this.value() & flagValue, flagValue);
    }

    @Override
    @Nonnull
    public F add(@Nonnull Long flagValue) {
        long value = (Long)this.value();
        long newFlagValue = value | flagValue;
        if (newFlagValue == value) {
            return (F)this;
        }
        return this.createFlag(newFlagValue);
    }

    @Override
    @Nonnull
    public F remove(@Nonnull Long flag) {
        long value = (Long)this.value();
        long newFlagValue = value & (flag ^ 0xFFFFFFFFFFFFFFFFL);
        if (newFlagValue == value) {
            return (F)this;
        }
        return this.createFlag(newFlagValue);
    }

    public boolean equals(Object obj) {
        return Flags.equals(this, obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.value());
    }

    public String toString() {
        long value = (Long)this.value();
        Enum[] enums = (Enum[])this.enumType().getEnumConstants();
        StringBuilder builder = new StringBuilder();
        for (int i = enums.length - 1; i >= 0; --i) {
            Enum item = enums[i];
            if ((value & (Long)((Valuable)((Object)item)).value()) != (Long)((Valuable)((Object)item)).value()) continue;
            if (builder.length() > 0) {
                builder.insert(0, item.name() + "|");
            } else {
                builder.append(item.name());
            }
            if ((value &= (Long)((Valuable)((Object)item)).value() ^ 0xFFFFFFFFFFFFFFFFL) == 0L) break;
        }
        if (value != 0L) {
            LongFlags.appendFlag(builder, Long.toUnsignedString(value));
        }
        if (builder.length() < 1) {
            return ((Long)this.value()).toString();
        }
        return builder.toString();
    }

    @Nonnull
    protected abstract F createFlag(long var1);

    private static void appendFlag(@Nonnull StringBuilder builder, @Nonnull String name) {
        if (builder.length() > 0) {
            builder.append("|");
        }
        builder.append(name);
    }
}

