/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.EnumFlags;
import cn.maarlakes.enumx.Flags;
import cn.maarlakes.enumx.Valuable;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public abstract class IntFlags<F extends IntFlags<F, E>, E extends Enum<E>>
implements EnumFlags<F, E, Integer> {
    @Override
    public boolean contains(Integer flagValue) {
        if (flagValue == null) {
            return false;
        }
        return Objects.equals((Integer)this.value() & flagValue, flagValue);
    }

    @Override
    @Nonnull
    public F add(@Nonnull Integer flagValue) {
        int value = (Integer)this.value();
        int newFlagValue = value | flagValue;
        if (newFlagValue == value) {
            return (F)this;
        }
        return this.createFlag(newFlagValue);
    }

    @Override
    @Nonnull
    public F remove(@Nonnull Integer flag) {
        int value = (Integer)this.value();
        int newFlagValue = value & ~flag.intValue();
        if (newFlagValue == value) {
            return (F)this;
        }
        return this.createFlag(newFlagValue);
    }

    public boolean equals(Object obj) {
        return Flags.equals(this, obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.value());
    }

    public String toString() {
        int value = (Integer)this.value();
        Enum[] enums = (Enum[])this.enumType().getEnumConstants();
        StringBuilder builder = new StringBuilder();
        for (int i = enums.length - 1; i >= 0; --i) {
            Enum item = enums[i];
            if ((value & (Integer)((Valuable)((Object)item)).value()) != (Integer)((Valuable)((Object)item)).value()) continue;
            if (builder.length() > 0) {
                builder.insert(0, item.name() + "|");
            } else {
                builder.append(item.name());
            }
            if ((value &= ~((Integer)((Valuable)((Object)item)).value()).intValue()) == 0) break;
        }
        if (value != 0) {
            IntFlags.appendFlag(builder, Integer.toUnsignedString(value));
        }
        if (builder.length() < 1) {
            return ((Integer)this.value()).toString();
        }
        return builder.toString();
    }

    @Nonnull
    protected abstract F createFlag(int var1);

    protected static void appendFlag(@Nonnull StringBuilder builder, @Nonnull String name) {
        if (builder.length() > 0) {
            builder.append("|");
        }
        builder.append(name);
    }
}

