/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.ClassUtils;
import cn.maarlakes.enumx.EnumFlags;
import cn.maarlakes.enumx.ValueUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;

public final class Flags {
    private Flags() {
    }

    @Nonnull
    public static <F extends EnumFlags<F, E, V>, E extends Enum<E>, V> Class<V> getValueType(@Nonnull Class<F> clazz) {
        return ValueUtils.getValueType(clazz);
    }

    public static <F extends EnumFlags<F, E, V>, E extends Enum<E>, V> F valueOf(@Nonnull Class<F> flagsType, @Nonnull Object value) {
        return Flags.valueOf(flagsType, Flags.getValueType(flagsType), value, false);
    }

    public static <F extends EnumFlags<F, E, V>, E extends Enum<E>, V> F valueOf(@Nonnull Class<F> flagsType, @Nonnull Class<V> valueType, @Nonnull Object value) {
        return Flags.valueOf(flagsType, valueType, value, false);
    }

    @Nonnull
    public static <F extends EnumFlags<F, E, V>, E extends Enum<E>, V> F valueOf(@Nonnull Class<F> flagsType, @Nonnull Object value, boolean primitiveConvert) {
        return Flags.valueOf(flagsType, Flags.getValueType(flagsType), value, primitiveConvert);
    }

    @Nonnull
    public static <F extends EnumFlags<F, E, V>, E extends Enum<E>, V> F valueOf(@Nonnull Class<F> flagsType, @Nonnull Class<V> valueType, @Nonnull Object value, boolean primitiveConvert) {
        Object obj;
        Object obj2;
        Class<?> primitiveType = ClassUtils.getPrimitiveType(valueType);
        Method createMethod = Flags.findCreateMethod(flagsType, valueType, primitiveType);
        if (createMethod != null && (obj2 = Flags.invokeMethod(createMethod, value, primitiveConvert)) != null) {
            return (F)((EnumFlags)obj2);
        }
        Constructor<?> constructor = Flags.findConstructor(flagsType, valueType, primitiveType);
        if (constructor != null && (obj = Flags.invokeConstructor(constructor, value, primitiveConvert)) != null) {
            return (F)((EnumFlags)obj);
        }
        throw new IllegalArgumentException("No flags value  " + flagsType.getName());
    }

    static <F extends EnumFlags<F, E, V>, E extends Enum<E>, V> boolean equals(F left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        Object rightValue = ((EnumFlags)right).value();
        return Objects.equals(left.value(), rightValue);
    }

    private static Object invokeMethod(@Nonnull Method method, @Nonnull Object value, boolean primitiveConvert) {
        Object param = Flags.castValue(value, method.getParameterTypes()[0], value.getClass(), primitiveConvert);
        if (param != null) {
            try {
                AccessController.doPrivileged(() -> {
                    method.setAccessible(true);
                    return null;
                });
                return method.invoke(null, param);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private static Method findCreateMethod(@Nonnull Class<?> flagsType, @Nonnull Class<?> valueType, Class<?> primitiveType) {
        return Arrays.stream(flagsType.getDeclaredMethods()).filter(item -> Modifier.isStatic(item.getModifiers())).filter(item -> item.getParameterCount() == 1).filter(item -> item.getReturnType() == flagsType).filter(item -> {
            Class<?> parameterType = item.getParameterTypes()[0];
            if (parameterType.isAssignableFrom(valueType)) {
                return true;
            }
            return primitiveType == parameterType;
        }).findFirst().orElse(null);
    }

    private static Object invokeConstructor(@Nonnull Constructor<?> constructor, @Nonnull Object value, boolean primitiveConvert) {
        Object param = Flags.castValue(value, constructor.getParameterTypes()[0], value.getClass(), primitiveConvert);
        if (param != null) {
            try {
                AccessController.doPrivileged(() -> {
                    constructor.setAccessible(true);
                    return null;
                });
                return constructor.newInstance(param);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private static Constructor<?> findConstructor(@Nonnull Class<?> flagsType, @Nonnull Class<?> valueType, Class<?> primitiveType) {
        return Arrays.stream(flagsType.getDeclaredConstructors()).filter(item -> item.getParameterCount() == 1).filter(item -> {
            Class<?> parameterType = item.getParameterTypes()[0];
            if (parameterType.isAssignableFrom(valueType)) {
                return true;
            }
            return primitiveType == parameterType;
        }).findFirst().orElse(null);
    }

    private static Object castValue(@Nonnull Object value, @Nonnull Class<?> parameterType, Class<?> valueType, boolean primitiveConvert) {
        Object castValue;
        if (parameterType.isAssignableFrom(valueType)) {
            return value;
        }
        if (parameterType.isPrimitive() && ClassUtils.getPrimitiveType(valueType) == parameterType) {
            return value;
        }
        if (valueType.isPrimitive() && ClassUtils.getPrimitiveType(parameterType) == valueType) {
            return value;
        }
        if (primitiveConvert && (castValue = ClassUtils.convertPrimitive(parameterType, value)) != null) {
            return castValue;
        }
        return null;
    }
}

