/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.Valuable;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public interface EnumValue<E extends Enum<E>, T>
extends Valuable<T> {
    @Nonnull
    public Class<E> getDeclaringClass();

    @Nonnull
    public static <E extends Enum<E>, T> E valueOf(@Nonnull Class<E> enumType, @Nonnull T value) {
        Enum[] values;
        Objects.requireNonNull(value, "Value is null");
        for (Enum item : values = (Enum[])enumType.getEnumConstants()) {
            if (!Objects.equals(((Valuable)((Object)item)).value(), value)) continue;
            return (E)item;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + " value: " + value);
    }

    @Nonnull
    public static <E extends Enum<E>, V> String toString(@Nonnull E e) {
        Object value = ((Valuable)((Object)e)).value();
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return String.format("%s: %s", e.name(), value);
    }

    public static <E extends Enum<E>, V> int compare(E left, E right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        Class type = ((Valuable)((Object)left)).valueType();
        if (Comparable.class.isAssignableFrom(type)) {
            Comparable comparable = (Comparable)((Valuable)((Object)left)).value();
            return comparable.compareTo(((Valuable)((Object)right)).value());
        }
        return left.compareTo(right);
    }
}

