/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.Enums;
import cn.maarlakes.enumx.Valuable;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface EnumFlags<F extends EnumFlags<F, E, V>, E extends Enum<E>, V>
extends Iterable<E>,
Valuable<V> {
    default public boolean contains(F flag) {
        if (flag == null) {
            return false;
        }
        return this.contains((V)flag.value());
    }

    default public boolean contains(E enumValue) {
        if (enumValue == null) {
            return false;
        }
        return this.contains((V)((Valuable)enumValue).value());
    }

    public boolean contains(V var1);

    @Nonnull
    default public F add(@Nonnull F flag) {
        if (this.value().equals(flag.value())) {
            return (F)this;
        }
        return this.add((V)flag.value());
    }

    @Nonnull
    default public F add(@Nonnull E flag) {
        if (this.value().equals(((Valuable)flag).value())) {
            return (F)this;
        }
        return this.add((V)((Valuable)flag).value());
    }

    @Nonnull
    public F add(@Nonnull V var1);

    @Nonnull
    default public F remove(@Nonnull F flag) {
        return this.remove((V)flag.value());
    }

    @Nonnull
    default public F remove(@Nonnull E flag) {
        return this.remove((V)((Valuable)flag).value());
    }

    @Nonnull
    public F remove(@Nonnull V var1);

    default public boolean isDefined() {
        return Enums.exists(this.enumType(), this.value());
    }

    @Nonnull
    default public E[] toEnumArray() {
        ArrayList<Enum> list = new ArrayList<Enum>();
        for (Enum item : (Enum[])this.enumType().getEnumConstants()) {
            if (!this.contains((V)item)) continue;
            list.add(item);
        }
        return list.toArray((Enum[])Array.newInstance(this.enumType(), list.size()));
    }

    @Nonnull
    public Class<E> enumType();

    @Override
    @Nonnull
    default public Iterator<E> iterator() {
        final Enum[] array = (Enum[])this.enumType().getEnumConstants();
        return new Iterator<E>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < array.length) {
                    if (EnumFlags.this.contains(array[this.index])) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return array[this.index++];
                }
                throw new NoSuchElementException();
            }
        };
    }
}

