/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.enumx;

import cn.maarlakes.enumx.StringUtils;

final class ClassUtils {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private ClassUtils() {
    }

    static boolean isPrimitiveWrapper(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Byte.class || clazz == Character.class;
    }

    static Class<?> getPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Short.TYPE;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.TYPE;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.TYPE;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.TYPE;
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Character.TYPE;
        }
        return null;
    }

    static Object convertPrimitive(Class<?> clazz, Object value) {
        if (value == null) {
            return null;
        }
        if (clazz == value.getClass()) {
            return value;
        }
        String str = value.toString();
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return ClassUtils.toBoolean(value);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return ClassUtils.toByte(value);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return ClassUtils.toShort(value);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return ClassUtils.toInteger(value);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return ClassUtils.toLong(value);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return ClassUtils.toFloat(value);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return ClassUtils.toDouble(value);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return ClassUtils.toCharacter(value);
        }
        throw new IllegalArgumentException("Class not primitive type.");
    }

    private static Object toBoolean(Object value) {
        String str = value.toString();
        if (TRUE.equalsIgnoreCase(str)) {
            return true;
        }
        if (FALSE.equalsIgnoreCase(str)) {
            return false;
        }
        return Boolean.parseBoolean(str);
    }

    private static Object toByte(Object value) {
        return Byte.parseByte(value.toString());
    }

    private static Object toShort(Object value) {
        return Short.parseShort(value.toString());
    }

    private static Object toInteger(Object value) {
        return Integer.parseInt(value.toString());
    }

    private static Object toLong(Object value) {
        return Long.parseLong(value.toString());
    }

    private static Object toFloat(Object value) {
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    private static Object toDouble(Object value) {
        return Double.parseDouble(value.toString());
    }

    private static Object toCharacter(Object value) {
        String str = value.toString();
        if (str.length() == 1) {
            return Character.valueOf(str.toCharArray()[0]);
        }
        return null;
    }
}

