/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import cn.maarlakes.common.utils.StreamUtils;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Enumeration;

public final class RsaUtils {
    private RsaUtils() {
    }

    @Nonnull
    public static PrivateKey loadPrivateKey(@Nonnull File privateKeyFile, String keyPwd) throws Exception {
        try (InputStream input = Files.newInputStream(privateKeyFile.toPath(), new OpenOption[0]);){
            PrivateKey privateKey = RsaUtils.loadPrivateKey(input, keyPwd);
            return privateKey;
        }
    }

    @Nonnull
    public static PrivateKey loadPrivateKey(InputStream privateKeyData, String keyPwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] pwdChars = keyPwd.toCharArray();
        keyStore.load(privateKeyData, pwdChars);
        String keyAlias = null;
        Enumeration<String> aliases = keyStore.aliases();
        if (aliases.hasMoreElements()) {
            keyAlias = aliases.nextElement();
        }
        Key key = keyStore.getKey(keyAlias, pwdChars);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(pkcs8EncodedKeySpec);
    }

    public static PublicKey loadPublicKey(File publicKeyFile) throws Exception {
        try (InputStream input = Files.newInputStream(publicKeyFile.toPath(), new OpenOption[0]);){
            PublicKey publicKey = RsaUtils.loadPublicKey(input);
            return publicKey;
        }
    }

    public static PublicKey loadPublicKey(InputStream publicKeyData) throws Exception {
        byte[] buffer = StreamUtils.readAllBytes(publicKeyData);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        BufferedReader br = new BufferedReader(new StringReader(new String(buffer)));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-")) continue;
            builder.append(line);
        }
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(builder.toString())));
        PublicKey publicKey = certificate.getPublicKey();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }
}

