/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.util.Optional;

public final class Numbers {
    private Numbers() {
    }

    public static byte convertToByte(Object value) {
        return Numbers.convertToByte(value, 10);
    }

    public static byte convertToByte(Object value, int radix) {
        return Numbers.convertToByteOptional(value, radix).orElse((byte)0);
    }

    @Nonnull
    public static Optional<Byte> convertToByteOptional(Object value) {
        return Numbers.convertToByteOptional(value, 10);
    }

    @Nonnull
    public static Optional<Byte> convertToByteOptional(Object value, int radix) {
        if (value instanceof Optional) {
            return Numbers.convertToByteOptional(((Optional)value).orElse(null), radix);
        }
        if (value instanceof Number) {
            return Optional.of(((Number)value).byteValue());
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Byte.parseByte(value.toString(), radix));
    }

    public static short convertToShort(Object value) {
        return Numbers.convertToShort(value, 10);
    }

    public static short convertToShort(Object value, int radix) {
        return Numbers.convertToShortOptional(value, radix).orElse((short)0);
    }

    @Nonnull
    public static Optional<Short> convertToShortOptional(Object value) {
        return Numbers.convertToShortOptional(value, 10);
    }

    @Nonnull
    public static Optional<Short> convertToShortOptional(Object value, int radix) {
        if (value instanceof Optional) {
            return Numbers.convertToShortOptional(((Optional)value).orElse(null), radix);
        }
        if (value instanceof Number) {
            return Optional.of(((Number)value).shortValue());
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Short.parseShort(value.toString(), radix));
    }

    public static int convertToInteger(Object value) {
        return Numbers.convertToInteger(value, 10);
    }

    public static int convertToInteger(Object value, int radix) {
        return Numbers.convertToIntegerOptional(value, radix).orElse(0);
    }

    @Nonnull
    public static Optional<Integer> convertToIntegerOptional(Object value) {
        return Numbers.convertToIntegerOptional(value, 10);
    }

    @Nonnull
    public static Optional<Integer> convertToIntegerOptional(Object value, int radix) {
        if (value instanceof Optional) {
            return Numbers.convertToIntegerOptional(((Optional)value).orElse(null), radix);
        }
        if (value instanceof Number) {
            return Optional.of(((Number)value).intValue());
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(value.toString(), radix));
    }

    public static long convertToLong(Object value) {
        return Numbers.convertToLong(value, 10);
    }

    public static long convertToLong(Object value, int radix) {
        return Numbers.convertToLongOptional(value, radix).orElse(0L);
    }

    @Nonnull
    public static Optional<Long> convertToLongOptional(Object value) {
        return Numbers.convertToLongOptional(value, 10);
    }

    @Nonnull
    public static Optional<Long> convertToLongOptional(Object value, int radix) {
        if (value instanceof Optional) {
            return Numbers.convertToLongOptional(((Optional)value).orElse(null), radix);
        }
        if (value instanceof Number) {
            return Optional.of(((Number)value).longValue());
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Long.parseLong(value.toString(), radix));
    }

    public static float convertToFloat(Object value) {
        return Numbers.convertToFloatOptional(value).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Nonnull
    public static Optional<Float> convertToFloatOptional(Object value) {
        if (value instanceof Optional) {
            return Numbers.convertToFloatOptional(((Optional)value).orElse(null));
        }
        if (value instanceof Number) {
            return Optional.of(Float.valueOf(((Number)value).floatValue()));
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(Float.parseFloat(value.toString())));
    }

    public static double convertToDouble(Object value) {
        return Numbers.convertToDoubleOptional(value).orElse(0.0);
    }

    @Nonnull
    public static Optional<Double> convertToDoubleOptional(Object value) {
        if (value instanceof Optional) {
            return Numbers.convertToDoubleOptional(((Optional)value).orElse(null));
        }
        if (value instanceof Number) {
            return Optional.of(((Number)value).doubleValue());
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Double.parseDouble(value.toString()));
    }

    public static BigDecimal convertToBigDecimal(Object value) {
        return Numbers.convertToBigDecimalOptional(value).orElse(BigDecimal.ZERO);
    }

    @Nonnull
    public static Optional<BigDecimal> convertToBigDecimalOptional(Object value) {
        if (value instanceof Optional) {
            return Numbers.convertToBigDecimalOptional(((Optional)value).orElse(null));
        }
        if (value instanceof Double || value instanceof Float) {
            return Optional.of(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(value.toString()));
    }
}

