/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

public final class Futures {
    private Futures() {
    }

    public static <T> T await(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getMessage(), e.getCause());
        }
        catch (CancellationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Nonnull
    public static <T> CompletableFuture<T> toCompletableFuture(@Nonnull Future<T> future) {
        if (future.isDone()) {
            return Futures.transformDoneFuture(future);
        }
        if (future instanceof CompletableFuture) {
            return (CompletableFuture)future;
        }
        if (future instanceof CompletionStage) {
            return ((CompletionStage)((Object)future)).toCompletableFuture();
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> {
            try {
                if (!future.isDone()) {
                    Futures.awaitFuture(future);
                }
                return future.get();
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
        completableFuture.whenComplete((r, e) -> {
            if (completableFuture.isCancelled()) {
                future.cancel(true);
            }
        });
        return completableFuture;
    }

    private static <T> void awaitFuture(final @Nonnull Future<T> future) throws InterruptedException {
        ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

            @Override
            public boolean block() throws InterruptedException {
                if (!this.isReleasable()) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public boolean isReleasable() {
                return future.isDone();
            }
        });
    }

    private static <T> CompletableFuture<T> transformDoneFuture(@Nonnull Future<T> future) {
        CompletableFuture<T> completableFuture = new CompletableFuture<T>();
        if (future.isCancelled()) {
            completableFuture.cancel(true);
        } else {
            try {
                completableFuture.complete(future.get());
            }
            catch (Throwable error) {
                completableFuture.completeExceptionally(error);
            }
        }
        return completableFuture;
    }
}

