/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.utils;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.StreamSupport;

public final class Comparators {
    private Comparators() {
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T min(T ... array) {
        return (T)((Comparable)Comparators.minOptional(array).orElse(null));
    }

    @Nonnull
    @SafeVarargs
    public static <T extends Comparable<? super T>> Optional<T> minOptional(T ... array) {
        return Comparators.minOptional(array, Comparator.naturalOrder());
    }

    @SafeVarargs
    public static <T> T min(@Nonnull Comparator<? super T> comparator, T ... array) {
        return Comparators.min(array, comparator);
    }

    @Nonnull
    @SafeVarargs
    public static <T> Optional<T> minOptional(@Nonnull Comparator<? super T> comparator, T ... array) {
        return Comparators.minOptional(array, comparator);
    }

    public static <T> T min(@Nonnull T[] array, @Nonnull Comparator<? super T> comparator) {
        return Comparators.minOptional(array, comparator).orElse(null);
    }

    @Nonnull
    public static <T> Optional<T> minOptional(@Nonnull T[] array, @Nonnull Comparator<? super T> comparator) {
        return Arrays.stream(array).min(comparator);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T max(T ... array) {
        return (T)((Comparable)Comparators.maxOptional(array, Comparator.naturalOrder()).orElse(null));
    }

    @Nonnull
    @SafeVarargs
    public static <T extends Comparable<? super T>> Optional<T> maxOptional(T ... array) {
        return Comparators.maxOptional(array, Comparator.naturalOrder());
    }

    @SafeVarargs
    public static <T> T max(@Nonnull Comparator<? super T> comparator, T ... array) {
        return Comparators.maxOptional(array, comparator).orElse(null);
    }

    @Nonnull
    @SafeVarargs
    public static <T> Optional<T> maxOptional(@Nonnull Comparator<? super T> comparator, T ... array) {
        return Comparators.maxOptional(array, comparator);
    }

    public static <T> T max(@Nonnull T[] array, @Nonnull Comparator<? super T> comparator) {
        return Comparators.maxOptional(array, comparator).orElse(null);
    }

    @Nonnull
    public static <T> Optional<T> maxOptional(@Nonnull T[] array, @Nonnull Comparator<? super T> comparator) {
        return Arrays.stream(array).max(comparator);
    }

    public static <T> T min(Iterable<T> list, @Nonnull Comparator<? super T> comparator) {
        return Comparators.minOptional(list, comparator).orElse(null);
    }

    @Nonnull
    public static <T> Optional<T> minOptional(Iterable<T> list, @Nonnull Comparator<? super T> comparator) {
        if (list instanceof Collection) {
            return ((Collection)list).stream().min(comparator);
        }
        return StreamSupport.stream(list.spliterator(), false).min(comparator);
    }

    public static <T> T max(@Nonnull Iterable<T> list, @Nonnull Comparator<? super T> comparator) {
        return Comparators.maxOptional(list, comparator).orElse(null);
    }

    @Nonnull
    public static <T> Optional<T> maxOptional(Iterable<T> list, Comparator<? super T> comparator) {
        if (list instanceof Collection) {
            return ((Collection)list).stream().max(comparator);
        }
        return StreamSupport.stream(list.spliterator(), false).max(comparator);
    }

    public static <T extends Comparable<? super T>> T min(@Nonnull Iterable<T> list) {
        return (T)((Comparable)Comparators.minOptional(list).orElse(null));
    }

    @Nonnull
    public static <T extends Comparable<? super T>> Optional<T> minOptional(@Nonnull Iterable<T> list) {
        return Comparators.minOptional(list, Comparator.naturalOrder());
    }

    public static <T extends Comparable<? super T>> T max(@Nonnull Iterable<T> list) {
        return (T)((Comparable)Comparators.maxOptional(list).orElse(null));
    }

    @Nonnull
    public static <T extends Comparable<? super T>> Optional<T> maxOptional(@Nonnull Iterable<T> list) {
        return Comparators.maxOptional(list, Comparator.naturalOrder());
    }

    public static <T extends Comparable<? super T>> T min(@Nonnull Iterator<T> iterator) {
        return (T)((Comparable)Comparators.minOptional(iterator).orElse(null));
    }

    @Nonnull
    public static <T extends Comparable<? super T>> Optional<T> minOptional(@Nonnull Iterator<T> iterator) {
        return Comparators.minOptional(iterator, Comparator.naturalOrder());
    }

    public static <T> T min(@Nonnull Iterator<T> iterator, Comparator<? super T> comparator) {
        return Comparators.minOptional(iterator, comparator).orElse(null);
    }

    @Nonnull
    public static <T> Optional<T> minOptional(@Nonnull Iterator<T> iterator, @Nonnull Comparator<? super T> comparator) {
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        T min = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (comparator.compare(min, next) <= 0) continue;
            min = next;
        }
        return Optional.ofNullable(min);
    }

    public static <T extends Comparable<? super T>> T max(@Nonnull Iterator<T> iterator) {
        return (T)((Comparable)Comparators.maxOptional(iterator).orElse(null));
    }

    @Nonnull
    public static <T extends Comparable<? super T>> Optional<T> maxOptional(@Nonnull Iterator<T> iterator) {
        return Comparators.maxOptional(iterator, Comparator.naturalOrder());
    }

    public static <T> T max(@Nonnull Iterator<T> iterator, @Nonnull Comparator<? super T> comparator) {
        return Comparators.maxOptional(iterator, comparator).orElse(null);
    }

    @Nonnull
    public static <T> Optional<T> maxOptional(@Nonnull Iterator<T> iterator, @Nonnull Comparator<? super T> comparator) {
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        T max = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (comparator.compare(max, next) >= 0) continue;
            max = next;
        }
        return Optional.ofNullable(max);
    }
}

