/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token.weixin;

import cn.maarlakes.common.token.weixin.WeixinToken;
import cn.maarlakes.common.token.weixin.WeixinTokenException;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;

public final class WeixinTokenUtils {
    private WeixinTokenUtils() {
    }

    @Nonnull
    public static WeixinToken toWeixinToken(@Nonnull String json, @Nonnull String appId, @Nonnull LocalDateTime now) {
        JSONObject obj = JSON.parseObject((String)json);
        String accessToken = obj.getString("access_token");
        if (accessToken == null || accessToken.isEmpty()) {
            throw new WeixinTokenException(obj.getIntValue("errcode", -1), obj.getString("errmsg"));
        }
        return WeixinToken.of(appId, accessToken, now.plusSeconds(obj.getLongValue("expires_in")));
    }
}

