/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token.weixin;

import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClients;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.token.weixin.AbstractWeixinTokenFactory;
import cn.maarlakes.common.token.weixin.WeixinSecretMapper;
import com.alibaba.fastjson2.JSONObject;
import jakarta.annotation.Nonnull;

public class StableWeixinTokenFactory
extends AbstractWeixinTokenFactory {
    private final WeixinSecretMapper secretMapper;
    private final boolean forceRefresh;

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper) {
        this(mapper, HttpClients.defaultClient());
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, boolean forceRefresh) {
        this(mapper, HttpClients.defaultClient(), forceRefresh);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull HttpClient httpClient) {
        this(mapper, httpClient, "https://api.weixin.qq.com/cgi-bin/stable_token", false);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull HttpClient httpClient, boolean forceRefresh) {
        this(mapper, httpClient, "https://api.weixin.qq.com/cgi-bin/stable_token", forceRefresh);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull String tokenUrl) {
        this(mapper, HttpClients.defaultClient(), tokenUrl, false);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull String tokenUrl, boolean forceRefresh) {
        this(mapper, HttpClients.defaultClient(), tokenUrl, forceRefresh);
    }

    public StableWeixinTokenFactory(@Nonnull WeixinSecretMapper mapper, @Nonnull HttpClient httpClient, @Nonnull String tokenUrl, boolean forceRefresh) {
        super(httpClient, tokenUrl);
        this.secretMapper = mapper;
        this.forceRefresh = forceRefresh;
    }

    @Override
    protected Request buildRequest(@Nonnull String appId) {
        JSONObject json = new JSONObject();
        json.put((Object)"grant_type", (Object)"client_credential");
        json.put((Object)"appid", (Object)appId);
        json.put((Object)"secret", (Object)this.secretMapper.getSecret(appId));
        json.put((Object)"force_refresh", (Object)this.forceRefresh);
        return Request.builder().post(this.url).json(json.toString()).build();
    }
}

