/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token.weixin;

import cn.maarlakes.common.token.weixin.WeixinToken;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.Objects;

class DefaultWeixinToken
implements WeixinToken {
    private static final long serialVersionUID = -60854212353897856L;
    private final String appId;
    private final String token;
    private final LocalDateTime expirationTime;

    DefaultWeixinToken(String appId, String token, LocalDateTime expirationTime) {
        this.appId = appId;
        this.token = token;
        this.expirationTime = expirationTime;
    }

    @Override
    @Nonnull
    public String getAppId() {
        return this.appId;
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }

    @Override
    @Nonnull
    public LocalDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeixinToken) {
            WeixinToken that = (WeixinToken)object;
            return Objects.equals(this.appId, that.getAppId()) && Objects.equals(this.token, that.getToken()) && Objects.equals(this.expirationTime, that.getExpirationTime());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.token, this.expirationTime);
    }

    public String toString() {
        return this.appId;
    }
}

