/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token.weixin;

import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.token.TokenException;
import cn.maarlakes.common.token.Tokens;
import cn.maarlakes.common.token.weixin.WeixinToken;
import cn.maarlakes.common.token.weixin.WeixinTokenFactory;
import cn.maarlakes.common.token.weixin.WeixinTokenUtils;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.concurrent.CompletionStage;

public abstract class AbstractWeixinTokenFactory
implements WeixinTokenFactory {
    protected final HttpClient httpClient;
    protected final String url;

    protected AbstractWeixinTokenFactory(@Nonnull HttpClient httpClient, @Nonnull String url) {
        this.httpClient = httpClient;
        this.url = url;
    }

    @Override
    @Nonnull
    public final CompletionStage<WeixinToken> createToken(@Nonnull String appId) {
        LocalDateTime now = LocalDateTime.now();
        return this.httpClient.execute(this.buildRequest(appId)).thenApply(response -> {
            if (response.getStatusCode() == 200) {
                return WeixinTokenUtils.toWeixinToken(response.getBody().asText(StandardCharsets.UTF_8), appId, now);
            }
            throw new TokenException("\u7f51\u7edc\u8bf7\u6c42\u9519\u8bef\uff0cHttpStatus:" + response.getStatusCode() + ", Description:" + response.getStatusText());
        }).exceptionally(error -> {
            throw Tokens.newTokenException(error);
        });
    }

    protected abstract Request buildRequest(@Nonnull String var1);
}

