/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token;

import cn.maarlakes.common.token.AppToken;
import cn.maarlakes.common.token.CacheableTokenRepository;
import cn.maarlakes.common.token.TokenFactory;
import cn.maarlakes.common.token.Tokens;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RMap;
import org.redisson.api.RSemaphore;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.Kryo5Codec;

public class RedissonCacheableAppTokenRepository<T extends AppToken<A, V>, A, V>
implements CacheableTokenRepository<T, A, V> {
    protected final RedissonClient client;
    protected final String namespace;
    protected final Codec codec = new Kryo5Codec();
    protected final TokenFactory<T, A, V> tokenFactory;
    protected final RMap<A, T> mapCache;

    public RedissonCacheableAppTokenRepository(@Nonnull RedissonClient client, @Nonnull String namespace, @Nonnull TokenFactory<T, A, V> tokenFactory) {
        this.client = client;
        this.namespace = namespace;
        this.tokenFactory = tokenFactory;
        this.mapCache = client.getLocalCachedMap(this.namespace, this.codec, LocalCachedMapOptions.defaults());
    }

    @Override
    @Nonnull
    public CompletionStage<List<T>> getTokensAsync() {
        return this.mapCache.readAllValuesAsync().thenApply(ArrayList::new);
    }

    @Override
    @Nonnull
    public CompletionStage<Void> clearAsync() {
        this.mapCache.clear();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    @Nonnull
    public CompletionStage<Void> removeAsync(@Nonnull A appId) {
        return this.mapCache.removeAsync(appId).thenRun(() -> {});
    }

    @Override
    @Nonnull
    public CompletionStage<Void> removeAsync(@Nonnull T token) {
        return this.mapCache.removeAsync(token.getAppId(), token).thenRun(() -> {});
    }

    @Override
    @Nonnull
    public CompletionStage<T> getTokenAsync(@Nonnull A appId) {
        return this.mapCache.getAsync(appId).thenCompose(token -> {
            if (token == null) {
                return this.createToken(appId);
            }
            return CompletableFuture.completedFuture(token);
        });
    }

    protected CompletionStage<? extends T> createToken(@Nonnull A appId) {
        RSemaphore semaphore = this.client.getSemaphore(this.namespace + ":lock:" + appId);
        return semaphore.trySetPermitsAsync(1).thenCompose(v -> semaphore.acquireAsync()).thenCompose(v -> this.mapCache.getAsync(appId)).thenCompose(token -> {
            if (token == null) {
                return this.tokenFactory.createToken(appId).thenCompose(t -> this.putTokenAsync(t).thenApply(tmp -> t));
            }
            return CompletableFuture.completedFuture(token);
        }).handle((r, e) -> {
            semaphore.releaseAsync();
            if (e != null) {
                throw Tokens.newTokenException(e);
            }
            return r;
        });
    }

    protected CompletionStage<? extends T> putTokenAsync(@Nonnull T token) {
        return this.mapCache.putAsync(token.getAppId(), token);
    }
}

