/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.token;

import cn.maarlakes.common.token.AppToken;
import cn.maarlakes.common.token.TokenRepository;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.concurrent.CompletionStage;

public interface CacheableTokenRepository<T extends AppToken<A, V>, A, V>
extends TokenRepository<T, A, V> {
    @Nonnull
    public CompletionStage<List<T>> getTokensAsync();

    @Nonnull
    default public List<T> getTokens() {
        return this.getTokensAsync().toCompletableFuture().join();
    }

    @Nonnull
    public CompletionStage<Void> clearAsync();

    default public void clear() {
        this.clearAsync().toCompletableFuture().join();
    }

    @Nonnull
    default public CompletionStage<Void> removeAsync(@Nonnull T token) {
        return this.removeAsync((A)token.getAppId());
    }

    default public void remove(@Nonnull T token) {
        this.removeAsync((A)token).toCompletableFuture().join();
    }

    @Nonnull
    public CompletionStage<Void> removeAsync(@Nonnull A var1);

    default public void remove(@Nonnull A appId) {
        this.removeAsync(appId).toCompletableFuture().join();
    }
}

