/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.id;

import cn.maarlakes.common.id.IdGenerator;
import jakarta.annotation.Nonnull;
import java.util.Random;

public final class SnowflakeIdGenerator
implements IdGenerator {
    private static final long TWEPOCH = 1585644268888L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 24L;
    private static final long TIMESTAMP_LEFT_SHIFT = 48L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = 0L;

    public SnowflakeIdGenerator() {
        this.workerId = new Random().nextInt(31);
        this.dataCenterId = new Random().nextInt(31);
    }

    public SnowflakeIdGenerator(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    @Override
    @Nonnull
    public synchronized String generateId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new IllegalStateException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.waitNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return Long.toUnsignedString(timestamp - 1585644268888L << 48 | this.dataCenterId << 24 | this.workerId << 12 | this.sequence);
    }

    private long waitNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

