/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.ok;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.body.ContentBody;
import cn.maarlakes.common.http.body.ContentChannel;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.Nullable;

class ContentRequestBody
extends RequestBody {
    private final ContentBody<?> body;
    private final ContentType contentType;

    ContentRequestBody(ContentBody<?> body) {
        this(body, body == null ? null : body.getContentType());
    }

    ContentRequestBody(ContentBody<?> body, ContentType contentType) {
        this.body = body;
        this.contentType = contentType;
    }

    @Nullable
    public MediaType contentType() {
        if (this.contentType == null) {
            return MediaType.parse((String)"application/text");
        }
        return MediaType.parse((String)ContentTypes.toString(this.contentType));
    }

    public void writeTo(@Nonnull BufferedSink bufferedSink) throws IOException {
        if (this.body instanceof ContentChannel) {
            ((ContentChannel)((Object)this.body)).transferTo((WritableByteChannel)bufferedSink);
        } else if (this.body != null) {
            this.body.writeTo((arg_0, arg_1, arg_2) -> ((BufferedSink)bufferedSink).write(arg_0, arg_1, arg_2));
        }
    }
}

