/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.body.multipart;

import cn.maarlakes.common.function.Consumer1;
import cn.maarlakes.common.function.Consumer3;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.RequestHeaders;
import cn.maarlakes.common.http.body.multipart.MultipartBody;
import cn.maarlakes.common.http.body.multipart.MultipartPart;
import cn.maarlakes.common.id.UlidGenerator;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class MultipartBodyBuilder
implements MultipartBody.Builder {
    private static final byte[] CRLF_BYTES = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_DISPOSITION_BYTES = "Content-Disposition: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FORM_DATA_DISPOSITION_TYPE_BYTES = "form-data".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NAME_BYTES = "; name=".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FILENAME_BYTES = "; filename=".getBytes(StandardCharsets.US_ASCII);
    static final byte[] QUOTE_BYTES = new byte[]{34};
    private static final byte[] CONTENT_TYPE_BYTES = "Content-Type: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_NAME_VALUE_SEPARATOR_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    private String boundary = UlidGenerator.getInstance().generateId();
    private ContentType contentType;
    private final List<MultipartPart<?>> parts = new ArrayList();

    MultipartBodyBuilder() {
    }

    @Override
    @Nonnull
    public MultipartBody.Builder boundary(@Nonnull String boundary) {
        this.boundary = Objects.requireNonNull(boundary);
        return this;
    }

    @Override
    @Nonnull
    public MultipartBody.Builder contentType(@Nonnull ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    @Nonnull
    public MultipartBody.Builder addPart(@Nonnull MultipartPart<?> part) {
        this.parts.add(part);
        return this;
    }

    @Override
    @Nonnull
    public MultipartBody build() {
        return new DefaultMultipartBody();
    }

    private static byte[] getContentDispositionBytes(@Nonnull MultipartPart<?> part) {
        String s;
        Header header = part.getHeaders().getHeader("Content-Disposition");
        if (header != null && (s = header.get()) != null && !s.isEmpty()) {
            return s.getBytes(StandardCharsets.US_ASCII);
        }
        return FORM_DATA_DISPOSITION_TYPE_BYTES;
    }

    private class DefaultMultipartBody
    implements MultipartBody {
        private DefaultMultipartBody() {
        }

        @Override
        @Nonnull
        public String getBoundary() {
            return MultipartBodyBuilder.this.boundary;
        }

        @Override
        public ContentType getContentType() {
            ContentType type = MultipartBodyBuilder.this.contentType == null ? ContentType.MULTIPART_FORM_DATA : MultipartBodyBuilder.this.contentType;
            return type.withParameter("boundary", MultipartBodyBuilder.this.boundary);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public InputStream getContentStream() {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.writeTo(out);
                out.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
                return byteArrayInputStream;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Collection<? extends MultipartPart<?>> getContent() {
            return MultipartBodyBuilder.this.parts;
        }

        @Override
        public int getContentLength() {
            return -1;
        }

        @Override
        public void writeTo(@Nonnull Consumer3<byte[], Integer, Integer> consumer) {
            byte[] boundaryBuffer = ("--" + MultipartBodyBuilder.this.boundary).getBytes(StandardCharsets.US_ASCII);
            Consumer1<byte[]> bufferConsumer = buffer -> consumer.acceptUnchecked((byte[])buffer, 0, ((byte[])buffer).length);
            for (MultipartPart part : MultipartBodyBuilder.this.parts) {
                bufferConsumer.acceptUnchecked(boundaryBuffer);
                bufferConsumer.acceptUnchecked(CRLF_BYTES);
                bufferConsumer.acceptUnchecked(CONTENT_DISPOSITION_BYTES);
                bufferConsumer.acceptUnchecked(MultipartBodyBuilder.getContentDispositionBytes(part));
                if (part.getName() != null) {
                    bufferConsumer.acceptUnchecked(NAME_BYTES);
                    bufferConsumer.acceptUnchecked(QUOTE_BYTES);
                    bufferConsumer.acceptUnchecked(part.getName().getBytes(StandardCharsets.US_ASCII));
                    bufferConsumer.acceptUnchecked(QUOTE_BYTES);
                }
                if (part.getFilename() != null) {
                    bufferConsumer.acceptUnchecked(FILENAME_BYTES);
                    bufferConsumer.acceptUnchecked(QUOTE_BYTES);
                    bufferConsumer.acceptUnchecked(part.getFilename().getBytes(StandardCharsets.US_ASCII));
                    bufferConsumer.acceptUnchecked(QUOTE_BYTES);
                }
                if (part.getContentType() != null) {
                    bufferConsumer.acceptUnchecked(CRLF_BYTES);
                    bufferConsumer.acceptUnchecked(CONTENT_TYPE_BYTES);
                    bufferConsumer.acceptUnchecked(ContentTypes.toString(part.getContentType()).getBytes(StandardCharsets.US_ASCII));
                }
                if (!part.getHeaders().isEmpty()) {
                    for (Header header : part.getHeaders()) {
                        if ("Content-Disposition".equalsIgnoreCase(header.getName())) continue;
                        bufferConsumer.acceptUnchecked(CRLF_BYTES);
                        bufferConsumer.acceptUnchecked(header.getName().getBytes(StandardCharsets.US_ASCII));
                        bufferConsumer.acceptUnchecked(HEADER_NAME_VALUE_SEPARATOR_BYTES);
                        bufferConsumer.acceptUnchecked(RequestHeaders.toString(header).getBytes(StandardCharsets.US_ASCII));
                    }
                }
                bufferConsumer.acceptUnchecked(CRLF_BYTES);
                bufferConsumer.acceptUnchecked(CRLF_BYTES);
                part.writeTo(consumer);
                bufferConsumer.acceptUnchecked(CRLF_BYTES);
            }
            bufferConsumer.acceptUnchecked(("--" + MultipartBodyBuilder.this.boundary + "--").getBytes(StandardCharsets.US_ASCII));
        }
    }
}

