/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.body;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.body.AbstractByteArrayBody;
import cn.maarlakes.common.http.body.BodyUtils;
import cn.maarlakes.common.http.body.TextBody;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DefaultTextBody
extends AbstractByteArrayBody<CharSequence>
implements TextBody {
    private final CharSequence content;
    private final ContentType contentType;

    public DefaultTextBody(@Nonnull CharSequence content) {
        this(content, ContentType.TEXT_PLAIN, StandardCharsets.UTF_8);
    }

    public DefaultTextBody(@Nonnull CharSequence content, Charset charset) {
        this(content, ContentType.TEXT_PLAIN, charset);
    }

    public DefaultTextBody(@Nonnull CharSequence content, @Nonnull ContentType contentType) {
        this(content, contentType, (String)null);
    }

    public DefaultTextBody(@Nonnull CharSequence content, @Nonnull ContentType contentType, Charset charset) {
        this.content = content;
        this.contentType = charset == null ? contentType : contentType.withCharset(charset);
    }

    public DefaultTextBody(@Nonnull CharSequence content, @Nonnull ContentType contentType, String charset) {
        this.content = content;
        this.contentType = charset == null ? contentType : contentType.withCharset(charset);
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public CharSequence getContent() {
        return this.content;
    }

    @Override
    protected byte[] contentAsBytes() {
        return BodyUtils.contentAsBytes(this.content, this.contentType.getCharset());
    }
}

