/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.async;

import cn.maarlakes.common.Order;
import cn.maarlakes.common.function.Function0;
import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClientFactory;
import cn.maarlakes.common.http.async.NettyAsyncHttpClient;
import cn.maarlakes.common.spi.SpiService;
import cn.maarlakes.common.utils.ClassUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import jakarta.annotation.Nonnull;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;

@Order(value=0x7FFFFFFF)
@SpiService(lifecycle=SpiService.Lifecycle.SINGLETON)
public class AsyncHttpClientFactory
implements HttpClientFactory {
    private static final boolean OK = ClassUtils.hasClass("org.asynchttpclient.AsyncHttpClient");

    @Override
    @Nonnull
    public HttpClient createClient() {
        return new NettyAsyncHttpClient();
    }

    @Override
    @Nonnull
    public HttpClient createClient(@Nonnull Function0<Executor> executorFactory) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        builder.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, executorFactory.get(), SelectorProvider.provider()));
        return new NettyAsyncHttpClient(Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)builder));
    }

    @Override
    public boolean isAvailable() {
        return OK;
    }
}

