/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.apache;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

class HttpEntityAsyncEntityProducer
implements AsyncEntityProducer {
    private final HttpEntity entity;
    private final AtomicReference<Exception> exception = new AtomicReference<Object>(null);

    public HttpEntityAsyncEntityProducer(@Nonnull HttpEntity entity) {
        this.entity = entity;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public String getContentType() {
        return this.entity.getContentType();
    }

    public String getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public Set<String> getTrailerNames() {
        return this.entity.getTrailerNames();
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public void produce(DataStreamChannel channel) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.entity.writeTo((OutputStream)out);
            ByteBuffer buffer = ByteBuffer.wrap(out.toByteArray());
            channel.write(buffer);
            channel.endStream();
            buffer.clear();
        }
    }

    public void releaseResources() {
        try {
            this.entity.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

