/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.apache;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.body.ContentBody;
import cn.maarlakes.common.http.body.ContentChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

class ContentAsyncEntityProducer
implements AsyncEntityProducer {
    private final ContentBody<?> body;
    private final AtomicReference<Exception> exception = new AtomicReference<Object>(null);

    ContentAsyncEntityProducer(ContentBody<?> body) {
        this.body = body;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        ContentType contentType = this.body.getContentType();
        return contentType == null ? null : ContentTypes.toString(contentType);
    }

    public String getContentEncoding() {
        return null;
    }

    public boolean isChunked() {
        return false;
    }

    public Set<String> getTrailerNames() {
        return null;
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public void produce(final DataStreamChannel channel) throws IOException {
        if (this.body instanceof ContentChannel) {
            ContentChannel contentChannel = (ContentChannel)((Object)this.body);
            contentChannel.transferTo(new WritableByteChannel(){

                @Override
                public int write(ByteBuffer src) throws IOException {
                    int count = channel.write(src);
                    channel.endStream();
                    return count;
                }

                @Override
                public boolean isOpen() {
                    return true;
                }

                @Override
                public void close() throws IOException {
                }
            });
        } else {
            this.body.writeTo((buffer, offset, length) -> {
                ByteBuffer buf = ByteBuffer.wrap(buffer, offset, length);
                channel.write(buf);
                channel.endStream();
                buf.clear();
            });
        }
    }

    public void releaseResources() {
    }
}

