/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.apache;

import cn.maarlakes.common.factory.datetime.DateTimeFactories;
import cn.maarlakes.common.http.ByteArrayResponseBody;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.DefaultHttpHeaders;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClientException;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.http.RequestConfig;
import cn.maarlakes.common.http.Response;
import cn.maarlakes.common.http.ResponseBody;
import cn.maarlakes.common.http.body.multipart.FilePart;
import cn.maarlakes.common.http.body.multipart.MultipartBody;
import cn.maarlakes.common.http.body.multipart.MultipartPart;
import cn.maarlakes.common.utils.CollectionUtils;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient4
implements HttpClient {
    private final org.apache.http.client.HttpClient client;
    private final Executor executor;

    public ApacheHttpClient4() {
        this((org.apache.http.client.HttpClient)HttpClientBuilder.create().build(), new ForkJoinPool());
    }

    public ApacheHttpClient4(@Nonnull Executor executor) {
        this((org.apache.http.client.HttpClient)HttpClientBuilder.create().build(), executor);
    }

    public ApacheHttpClient4(@Nonnull org.apache.http.client.HttpClient client) {
        this(client, new ForkJoinPool());
    }

    public ApacheHttpClient4(@Nonnull org.apache.http.client.HttpClient client, @Nonnull Executor executor) {
        this.client = client;
        this.executor = executor;
    }

    @Override
    @Nonnull
    public CompletionStage<? extends Response> execute(@Nonnull Request request, RequestConfig config) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                RequestBuilder builder = RequestBuilder.create((String)request.getMethod().name()).setUri(ApacheHttpClient4.toUri(request));
                ApacheHttpClient4.settingHeader(builder, request);
                if (request.getCharset() != null) {
                    builder.setCharset(request.getCharset());
                }
                ApacheHttpClient4.settingFormParams(builder, request);
                if (request.getBody() != null) {
                    if (request.getBody() instanceof MultipartBody) {
                        ApacheHttpClient4.settingMultipart(builder, (MultipartBody)request.getBody(), request.getCharset());
                    } else {
                        InputStream content = request.getBody().getContentStream();
                        if (content != null) {
                            builder.setEntity((HttpEntity)new InputStreamEntity(content, ApacheHttpClient4.toApacheContentType(request.getBody().getContentType())));
                        }
                    }
                }
                HttpClientContext context = HttpClientContext.create();
                context.setCookieStore((CookieStore)new BasicCookieStore());
                org.apache.http.client.config.RequestConfig requestConfig = ApacheHttpClient4.to(config);
                if (requestConfig != null) {
                    context.setRequestConfig(requestConfig);
                }
                if (CollectionUtils.isNotEmpty(request.getCookies())) {
                    builder.addHeader("Cookie", request.getCookies().stream().map(item -> item.name() + "=" + item.value()).collect(Collectors.joining(";")));
                }
                HttpUriRequest uriRequest = builder.build();
                return (Response)this.client.execute(ApacheHttpClient4.determineTarget(uriRequest), (HttpRequest)uriRequest, response -> new DefaultResponse(request.getUri(), response, (HttpContext)context), (HttpContext)context);
            }
            catch (Exception e) {
                throw new HttpClientException(e.getMessage(), e);
            }
        }, this.executor);
    }

    @Override
    public void close() throws IOException {
        if (this.client instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.client).close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    public static org.apache.http.entity.ContentType toApacheContentType(@Nonnull ContentType contentType) {
        org.apache.http.entity.ContentType result = org.apache.http.entity.ContentType.create((String)contentType.getMediaType(), (String)contentType.getCharset());
        if (CollectionUtils.isNotEmpty(contentType.getParameters())) {
            return result.withParameters((org.apache.http.NameValuePair[])contentType.getParameters().stream().map(item -> new BasicNameValuePair(item.getName(), item.getValue())).toArray(org.apache.http.NameValuePair[]::new));
        }
        return result;
    }

    private static org.apache.http.client.config.RequestConfig to(RequestConfig config) {
        if (config == null) {
            return null;
        }
        RequestConfig.Builder builder = org.apache.http.client.config.RequestConfig.custom();
        builder.setRedirectsEnabled(config.isRedirectsEnabled());
        if (config.getRequestTimeout() != null) {
            builder.setConnectionRequestTimeout((int)config.getRequestTimeout().toMillis());
        }
        if (config.getResponseTimeout() != null) {
            builder.setSocketTimeout((int)config.getResponseTimeout().toMillis());
        }
        if (config.getConnectTimeout() != null) {
            builder.setConnectTimeout((int)config.getConnectTimeout().toMillis());
        }
        return builder.build();
    }

    @Nonnull
    private static URI toUri(@Nonnull Request request) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(request.getUri());
        if (CollectionUtils.isNotEmpty(request.getQueryParams())) {
            for (NameValuePair nameValuePair : request.getQueryParams()) {
                builder.addParameter(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        return builder.build();
    }

    private static void settingMultipart(@Nonnull RequestBuilder builder, @Nonnull MultipartBody body, Charset charset) {
        if (CollectionUtils.isNotEmpty((Collection)body.getContent())) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setContentType(org.apache.http.entity.ContentType.parse((String)ContentTypes.toString(body.getContentType())));
            for (MultipartPart part : (Collection)body.getContent()) {
                Object contentBody = part instanceof FilePart ? (part.getContentType() == null ? new FileBody((File)((FilePart)part).getContent()) : new FileBody((File)((FilePart)part).getContent(), ApacheHttpClient4.toApacheContentType(part.getContentType()), part.getFilename())) : (part.getContentType() == null ? new InputStreamBody(part.getContentStream(), part.getFilename()) : new InputStreamBody(part.getContentStream(), ApacheHttpClient4.toApacheContentType(part.getContentType()), part.getFilename()));
                FormBodyPartBuilder partBuilder = FormBodyPartBuilder.create((String)part.getName(), (ContentBody)contentBody);
                if (!part.getHeaders().isEmpty()) {
                    for (Header header : part.getHeaders()) {
                        for (String s : header.getValues()) {
                            if (s == null) continue;
                            partBuilder.addField(header.getName(), s);
                        }
                    }
                }
                multipartEntityBuilder.addPart(partBuilder.build());
            }
            if (charset != null) {
                multipartEntityBuilder.setCharset(charset);
            }
            builder.setEntity(multipartEntityBuilder.build());
        }
    }

    private static void settingFormParams(@Nonnull RequestBuilder builder, @Nonnull Request request) {
        if (CollectionUtils.isNotEmpty(request.getFormParams())) {
            for (NameValuePair nameValuePair : request.getFormParams()) {
                builder.addParameter(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
    }

    private static void settingHeader(@Nonnull RequestBuilder builder, @Nonnull Request request) {
        if (!request.getHeaders().isEmpty()) {
            for (Header header : request.getHeaders()) {
                for (String value : header.getValues()) {
                    builder.addHeader(header.getName(), value);
                }
            }
        }
    }

    private static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI uri = request.getURI();
        if (uri.isAbsolute() && (target = URIUtils.extractHost((URI)uri)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + uri);
        }
        return target;
    }

    private static class DefaultResponse
    implements Response {
        private final URI uri;
        private final HttpResponse response;
        private final HttpContext context;
        private final SocketAddress remoteAddress;
        private final ResponseBody body;

        private DefaultResponse(URI uri, HttpResponse response, HttpContext context) {
            byte[] buffer;
            this.uri = uri;
            this.response = response;
            Object attribute = context.getAttribute("http.connection");
            if (attribute instanceof HttpInetConnection) {
                HttpInetConnection connection = (HttpInetConnection)attribute;
                this.remoteAddress = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            } else {
                this.remoteAddress = null;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                buffer = new byte[]{};
            } else {
                try {
                    buffer = EntityUtils.toByteArray((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.body = new ByteArrayResponseBody(buffer, Optional.ofNullable(response.getEntity()).map(HttpEntity::getContentType).map(Object::toString).map(ContentType::parse).orElse(null), this.getHeaders().getHeader("content-encoding"));
            this.context = context;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public String getStatusText() {
            return this.response.getStatusLine().getReasonPhrase();
        }

        @Override
        @Nonnull
        public ResponseBody getBody() {
            return this.body;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            TreeMap<String, List> map = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
            for (org.apache.http.Header header : this.response.getAllHeaders()) {
                map.computeIfAbsent(header.getName(), k -> new ArrayList()).add(header.getValue());
            }
            TreeMap<String, Header> headers = new TreeMap<String, Header>(String.CASE_INSENSITIVE_ORDER);
            map.forEach((k, v) -> {
                Header cfr_ignored_0 = headers.put((String)k, new DefaultHeader((String)k, (Collection<String>)v));
            });
            return new DefaultHttpHeaders(headers);
        }

        @Override
        @Nonnull
        public List<? extends Cookie> getCookies() {
            CookieStore cookieStore = (CookieStore)this.context.getAttribute("http.cookie-store");
            List cookies = cookieStore.getCookies();
            if (CollectionUtils.isEmpty(cookies)) {
                return new ArrayList();
            }
            ArrayList<Cookie> list = new ArrayList<Cookie>();
            for (org.apache.http.cookie.Cookie cookie : cookies) {
                Cookie.Builder builder = Cookie.builder(cookie.getName()).value(cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).isSecure(cookie.isSecure());
                if (cookie.getExpiryDate() != null) {
                    builder.expires(DateTimeFactories.fromEpochMilli(cookie.getExpiryDate().getTime()));
                }
                list.add(builder.build());
            }
            return list;
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }
}

