/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http.apache;

import cn.maarlakes.common.http.ByteArrayResponseBody;
import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.DefaultHttpHeaders;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpClient;
import cn.maarlakes.common.http.HttpClientException;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.http.RequestConfig;
import cn.maarlakes.common.http.Response;
import cn.maarlakes.common.http.ResponseBody;
import cn.maarlakes.common.http.apache.Apaches;
import cn.maarlakes.common.http.apache.ContentAsyncEntityProducer;
import cn.maarlakes.common.http.apache.HttpEntityAsyncEntityProducer;
import cn.maarlakes.common.http.body.multipart.FilePart;
import cn.maarlakes.common.http.body.multipart.MultipartBody;
import cn.maarlakes.common.utils.CollectionUtils;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.FormBodyPartBuilder;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.AbstractAsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Timeout;

public class ApacheAsyncHttpClient
implements HttpClient {
    private final HttpAsyncClient client;

    public ApacheAsyncHttpClient() {
        this((HttpAsyncClient)HttpAsyncClientBuilder.create().build());
    }

    public ApacheAsyncHttpClient(@Nonnull HttpAsyncClient httpClient) {
        CloseableHttpAsyncClient closeableHttpAsyncClient;
        this.client = httpClient;
        if (httpClient instanceof CloseableHttpAsyncClient && (closeableHttpAsyncClient = (CloseableHttpAsyncClient)httpClient).getStatus() != IOReactorStatus.ACTIVE) {
            closeableHttpAsyncClient.start();
        }
    }

    @Override
    @Nonnull
    public CompletionStage<? extends Response> execute(@Nonnull Request request, RequestConfig config) {
        try {
            AsyncRequestBuilder builder = AsyncRequestBuilder.create((String)request.getMethod().name()).setUri(Apaches.toUri(request));
            ApacheAsyncHttpClient.settingHeader(builder, request);
            if (request.getCharset() != null) {
                builder.setCharset(request.getCharset());
            }
            ApacheAsyncHttpClient.settingFormParams(builder, request);
            if (request.getBody() != null) {
                if (request.getBody() instanceof MultipartBody) {
                    ApacheAsyncHttpClient.settingMultipart(builder, (MultipartBody)request.getBody(), request.getCharset());
                } else {
                    builder.setEntity((AsyncEntityProducer)new ContentAsyncEntityProducer(request.getBody()));
                }
            }
            HttpClientContext context = HttpClientContext.create();
            context.setCookieStore((CookieStore)new BasicCookieStore());
            org.apache.hc.client5.http.config.RequestConfig requestConfig = ApacheAsyncHttpClient.to(config);
            if (requestConfig != null) {
                context.setRequestConfig(requestConfig);
            }
            if (CollectionUtils.isNotEmpty(request.getCookies())) {
                builder.addHeader("Cookie", request.getCookies().stream().map(item -> item.name() + "=" + item.value()).collect(Collectors.joining(";")));
            }
            final CompletableFuture future = new CompletableFuture();
            this.client.execute(builder.build(), (AsyncResponseConsumer)new ResponseAsyncResponseConsumer(request.getUri(), (HttpContext)context), null, (HttpContext)context, (FutureCallback)new FutureCallback<Response>(){

                public void completed(Response response) {
                    future.complete(response);
                }

                public void failed(Exception ex) {
                    future.completeExceptionally(new HttpClientException(ex.getMessage(), ex));
                }

                public void cancelled() {
                    future.cancel(true);
                }
            });
            return future;
        }
        catch (Exception e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new HttpClientException(e.getMessage(), e);
            });
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.client).close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private static org.apache.hc.client5.http.config.RequestConfig to(RequestConfig config) {
        if (config == null) {
            return null;
        }
        RequestConfig.Builder builder = org.apache.hc.client5.http.config.RequestConfig.custom();
        builder.setRedirectsEnabled(config.isRedirectsEnabled());
        if (config.getRequestTimeout() != null) {
            builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)config.getRequestTimeout().toMillis()));
        }
        if (config.getResponseTimeout() != null) {
            builder.setResponseTimeout(Timeout.ofMilliseconds((long)config.getResponseTimeout().toMillis()));
        }
        if (config.getConnectTimeout() != null) {
            builder.setConnectTimeout(Timeout.ofMilliseconds((long)config.getConnectTimeout().toMillis()));
        }
        return builder.build();
    }

    private static void settingFormParams(@Nonnull AsyncRequestBuilder builder, @Nonnull Request request) {
        if (CollectionUtils.isNotEmpty(request.getFormParams())) {
            for (NameValuePair nameValuePair : request.getFormParams()) {
                builder.addParameter(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
    }

    private static void settingHeader(@Nonnull AsyncRequestBuilder builder, @Nonnull Request request) {
        if (!request.getHeaders().isEmpty()) {
            for (Header header : request.getHeaders()) {
                for (String value : header.getValues()) {
                    builder.addHeader(header.getName(), value);
                }
            }
        }
    }

    private static void settingMultipart(@Nonnull AsyncRequestBuilder builder, @Nonnull MultipartBody body, Charset charset) {
        if (CollectionUtils.isNotEmpty((Collection)body.getContent())) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setContentType(Apaches.toApacheContentType(body.getContentType()));
            for (cn.maarlakes.common.http.body.multipart.MultipartPart part : (Collection)body.getContent()) {
                Object contentBody = part instanceof FilePart ? (part.getContentType() == null ? new FileBody((File)((FilePart)part).getContent()) : new FileBody((File)((FilePart)part).getContent(), Apaches.toApacheContentType(part.getContentType()), part.getFilename())) : (part.getContentType() == null ? new InputStreamBody(part.getContentStream(), part.getFilename()) : new InputStreamBody(part.getContentStream(), Apaches.toApacheContentType(part.getContentType()), part.getFilename()));
                FormBodyPartBuilder partBuilder = FormBodyPartBuilder.create((String)part.getName(), (ContentBody)contentBody);
                if (!part.getHeaders().isEmpty()) {
                    for (Header header : part.getHeaders()) {
                        for (String s : header.getValues()) {
                            if (s == null) continue;
                            partBuilder.addField(header.getName(), s);
                        }
                    }
                }
                multipartEntityBuilder.addPart((MultipartPart)partBuilder.build());
            }
            if (charset != null) {
                multipartEntityBuilder.setCharset(charset);
            }
            builder.setEntity((AsyncEntityProducer)new HttpEntityAsyncEntityProducer(multipartEntityBuilder.build()));
        }
    }

    private static class DefaultResponse
    implements Response {
        private final URI uri;
        private final HttpContext context;
        private final HttpResponse response;
        private final ResponseBody body;

        private DefaultResponse(@Nonnull URI uri, HttpContext context, @Nonnull HttpResponse response, byte[] bodyBuffer, org.apache.hc.core5.http.ContentType contentType) {
            this.uri = uri;
            this.context = context;
            this.response = response;
            this.body = new ByteArrayResponseBody(bodyBuffer == null ? new byte[]{} : bodyBuffer, ContentType.parse(contentType.toString()), this.getHeaders().getHeader("content-encoding"));
        }

        @Override
        public int getStatusCode() {
            return this.response.getCode();
        }

        @Override
        public String getStatusText() {
            return this.response.getReasonPhrase();
        }

        @Override
        @Nonnull
        public ResponseBody getBody() {
            return this.body;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            TreeMap<String, List> map = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
            for (org.apache.hc.core5.http.Header header : this.response.getHeaders()) {
                map.computeIfAbsent(header.getName(), k -> new ArrayList()).add(header.getValue());
            }
            TreeMap<String, Header> headers = new TreeMap<String, Header>(String.CASE_INSENSITIVE_ORDER);
            map.forEach((k, v) -> {
                Header cfr_ignored_0 = headers.put((String)k, new DefaultHeader((String)k, (Collection<String>)v));
            });
            return new DefaultHttpHeaders(headers);
        }

        @Override
        @Nonnull
        public List<? extends Cookie> getCookies() {
            CookieStore cookieStore = (CookieStore)this.context.getAttribute("http.cookie-store");
            List cookies = cookieStore.getCookies();
            if (CollectionUtils.isEmpty(cookies)) {
                return new ArrayList();
            }
            ArrayList<Cookie> list = new ArrayList<Cookie>();
            for (org.apache.hc.client5.http.cookie.Cookie cookie : cookies) {
                Cookie.Builder builder = Cookie.builder(cookie.getName()).value(cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).isSecure(cookie.isSecure());
                if (cookie.getCreationDate() != null && cookie.getExpiryDate() != null) {
                    builder.maxAge((cookie.getExpiryDate().getTime() - cookie.getCreationDate().getTime()) / 1000L);
                }
                builder.isHttpOnly(Boolean.parseBoolean(cookie.getAttribute("httponly")));
                String sameSite = cookie.getAttribute("samesite");
                if (sameSite == null) {
                    sameSite = cookie.getAttribute("same-site");
                }
                if (sameSite != null) {
                    builder.sameSite(Cookie.SameSite.of(sameSite));
                }
                list.add(builder.build());
            }
            return list;
        }

        @Override
        public SocketAddress getRemoteAddress() {
            EndpointDetails endpoint = (EndpointDetails)this.context.getAttribute("http.connection-endpoint");
            if (endpoint == null) {
                return null;
            }
            return endpoint.getRemoteAddress();
        }
    }

    private static class ResponseAsyncResponseConsumer
    extends AbstractAsyncResponseConsumer<Response, byte[]> {
        private final URI uri;
        private final HttpContext context;

        public ResponseAsyncResponseConsumer(@Nonnull URI uri, HttpContext context) {
            super((AsyncEntityConsumer)new BasicAsyncEntityConsumer());
            this.uri = uri;
            this.context = context;
        }

        protected Response buildResult(HttpResponse response, byte[] entity, org.apache.hc.core5.http.ContentType contentType) {
            return new DefaultResponse(this.uri, this.context, response, entity, contentType);
        }

        public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
        }
    }
}

