/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.DefaultNameValuePair;
import cn.maarlakes.common.http.DefaultRequestBuilder;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.HttpMethod;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.RequestBody;
import cn.maarlakes.common.http.body.DefaultTextBody;
import cn.maarlakes.common.http.body.JsonBody;
import cn.maarlakes.common.http.body.multipart.MultipartBody;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;

public interface Request {
    @Nonnull
    public HttpMethod getMethod();

    @Nonnull
    public URI getUri();

    @Nonnull
    public HttpHeaders getHeaders();

    @Nonnull
    public List<? extends Cookie> getCookies();

    public Charset getCharset();

    public List<? extends NameValuePair> getQueryParams();

    public List<? extends NameValuePair> getFormParams();

    public RequestBody<?> getBody();

    @Nonnull
    public static Builder builder() {
        return new DefaultRequestBuilder();
    }

    public static interface Builder {
        @Nonnull
        public Builder method(@Nonnull HttpMethod var1);

        @Nonnull
        default public Builder get(@Nonnull String url) {
            return this.method(HttpMethod.GET).uri(url);
        }

        @Nonnull
        default public Builder post(@Nonnull String url) {
            return this.method(HttpMethod.POST).uri(url);
        }

        @Nonnull
        default public Builder put(@Nonnull String url) {
            return this.method(HttpMethod.PUT).uri(url);
        }

        @Nonnull
        default public Builder delete(@Nonnull String url) {
            return this.method(HttpMethod.DELETE).uri(url);
        }

        @Nonnull
        default public Builder patch(@Nonnull String url) {
            return this.method(HttpMethod.PATCH).uri(url);
        }

        @Nonnull
        default public Builder uri(@Nonnull String url) {
            return this.uri(URI.create(url));
        }

        @Nonnull
        public Builder uri(@Nonnull URI var1);

        @Nonnull
        default public Builder setHeader(@Nonnull String name, @Nonnull String value) {
            return this.setHeader(new DefaultHeader(name, value));
        }

        @Nonnull
        public Builder setHeader(@Nonnull Header var1);

        @Nonnull
        default public Builder appendHeader(@Nonnull String name, @Nonnull String value) {
            return this.appendHeader(new DefaultHeader(name, value));
        }

        @Nonnull
        public Builder appendHeader(@Nonnull Header var1);

        @Nonnull
        default public Builder addCookie(@Nonnull String name, @Nonnull String value) {
            return this.addCookie(Cookie.builder(name).value(value).build());
        }

        @Nonnull
        public Builder addCookie(@Nonnull Cookie var1);

        @Nonnull
        public Builder charset(@Nonnull Charset var1);

        @Nonnull
        default public Builder addQueryParam(@Nonnull String name, String value) {
            return this.addQueryParam(new DefaultNameValuePair(name, value));
        }

        @Nonnull
        public Builder addQueryParam(@Nonnull NameValuePair var1);

        @Nonnull
        default public Builder addFormParam(@Nonnull String name, String value) {
            return this.addFormParam(new DefaultNameValuePair(name, value));
        }

        @Nonnull
        public Builder addFormParam(@Nonnull NameValuePair var1);

        @Nonnull
        public Builder body(@Nonnull RequestBody<?> var1);

        @Nonnull
        default public Builder multipartBody(@Nonnull MultipartBody.Builder builder) {
            return this.multipartBody(builder.build());
        }

        @Nonnull
        default public Builder multipartBody(@Nonnull MultipartBody body) {
            return this.body(body);
        }

        @Nonnull
        default public Builder text(@Nonnull String text) {
            return this.body(new DefaultTextBody((CharSequence)text, ContentType.TEXT_PLAIN));
        }

        @Nonnull
        default public Builder text(@Nonnull String text, String charset) {
            return this.body(new DefaultTextBody((CharSequence)text, ContentType.TEXT_PLAIN.withCharset(charset)));
        }

        @Nonnull
        default public Builder json(@Nonnull String json) {
            return this.body(new JsonBody(json));
        }

        @Nonnull
        default public Builder json(@Nonnull String json, String charset) {
            return this.body(new JsonBody((CharSequence)json, charset));
        }

        @Nonnull
        default public Builder json(@Nonnull String json, Charset charset) {
            return this.body(new JsonBody((CharSequence)json, charset));
        }

        @Nonnull
        default public Builder json(@Nonnull Object obj) {
            return this.body(new JsonBody(obj));
        }

        @Nonnull
        default public Builder json(@Nonnull Object obj, Charset charset) {
            return this.body(new JsonBody(obj, charset));
        }

        @Nonnull
        default public Builder json(@Nonnull Object obj, String charset) {
            return this.body(new JsonBody(obj, charset));
        }

        @Nonnull
        public Request build();
    }
}

