/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.DefaultHttpHeaders;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.HttpHeaders;
import cn.maarlakes.common.http.HttpMethod;
import cn.maarlakes.common.http.NameValuePair;
import cn.maarlakes.common.http.Request;
import cn.maarlakes.common.http.RequestBody;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class DefaultRequestBuilder
implements Request.Builder {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final List<NameValuePair> queryParams = new ArrayList<NameValuePair>();
    private final List<NameValuePair> formParams = new ArrayList<NameValuePair>();
    private HttpMethod method;
    private URI uri;
    private Charset charset;
    private RequestBody<?> body;

    DefaultRequestBuilder() {
    }

    @Override
    @Nonnull
    public Request.Builder method(@Nonnull HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder uri(@Nonnull URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder setHeader(@Nonnull Header header) {
        this.headers.put(header.getName(), new ArrayList<String>(header.getValues()));
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder appendHeader(@Nonnull Header header) {
        this.headers.computeIfAbsent(header.getName(), k -> new ArrayList()).addAll(header.getValues());
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder addCookie(@Nonnull Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder charset(@Nonnull Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder addQueryParam(@Nonnull NameValuePair param) {
        this.queryParams.add(param);
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder addFormParam(@Nonnull NameValuePair param) {
        this.formParams.add(param);
        return this;
    }

    @Override
    @Nonnull
    public Request.Builder body(@Nonnull RequestBody<?> body) {
        this.body = body;
        return this;
    }

    @Override
    @Nonnull
    public Request build() {
        return new DefaultRequest();
    }

    private class DefaultRequest
    implements Request {
        private DefaultRequest() {
        }

        @Override
        @Nonnull
        public HttpMethod getMethod() {
            return DefaultRequestBuilder.this.method;
        }

        @Override
        @Nonnull
        public URI getUri() {
            return DefaultRequestBuilder.this.uri;
        }

        @Override
        @Nonnull
        public HttpHeaders getHeaders() {
            TreeMap<String, Header> map = new TreeMap<String, Header>();
            DefaultRequestBuilder.this.headers.forEach((k, v) -> {
                Header cfr_ignored_0 = map.put((String)k, new DefaultHeader((String)k, (Collection<String>)v));
            });
            return new DefaultHttpHeaders(map);
        }

        @Override
        @Nonnull
        public List<? extends Cookie> getCookies() {
            return DefaultRequestBuilder.this.cookies;
        }

        @Override
        public Charset getCharset() {
            return DefaultRequestBuilder.this.charset;
        }

        @Override
        public List<? extends NameValuePair> getQueryParams() {
            return DefaultRequestBuilder.this.queryParams;
        }

        @Override
        public List<? extends NameValuePair> getFormParams() {
            return DefaultRequestBuilder.this.formParams;
        }

        @Override
        public RequestBody<?> getBody() {
            return DefaultRequestBuilder.this.body;
        }
    }
}

