/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.NameValuePair;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

final class DefaultContentType
implements ContentType {
    private static final long serialVersionUID = -3562691153207914795L;
    private final String mediaType;
    private final String charset;
    private final List<NameValuePair> parameters;

    DefaultContentType(@Nonnull String mediaType, String charset, @Nonnull Collection<? extends NameValuePair> parameters) {
        this.mediaType = mediaType;
        this.charset = charset;
        this.parameters = Collections.unmodifiableList(new ArrayList<NameValuePair>(parameters));
    }

    @Override
    @Nonnull
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public Collection<NameValuePair> getParameters() {
        return this.parameters;
    }

    @Override
    public String getParameter(@Nonnull String name) {
        for (NameValuePair parameter : this.parameters) {
            if (!name.equalsIgnoreCase(parameter.getName())) continue;
            return parameter.getValue();
        }
        return null;
    }

    @Override
    @Nonnull
    public ContentType withCharset(String charset) {
        if (Objects.equals(this.charset, charset)) {
            return this;
        }
        return new DefaultContentType(this.mediaType, charset, this.parameters);
    }

    @Override
    @Nonnull
    public ContentType withParameter(NameValuePair ... params) {
        TreeMap<String, NameValuePair> map = new TreeMap<String, NameValuePair>(String.CASE_INSENSITIVE_ORDER);
        for (NameValuePair parameter : this.parameters) {
            map.put(parameter.getName(), parameter);
        }
        for (NameValuePair parameter : params) {
            map.put(parameter.getName(), parameter);
        }
        return new DefaultContentType(this.mediaType, this.charset, map.values());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContentType) {
            ContentType that = (ContentType)obj;
            return this.mediaType.equalsIgnoreCase(that.getMediaType()) && Objects.equals(this.charset, that.getCharset()) && this.parameters.equals(that.getParameters());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mediaType, this.charset, this.parameters);
    }

    public String toString() {
        return this.toHeader().toString();
    }
}

