/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.factory.datetime.DateTimeFactories;
import cn.maarlakes.common.http.Cookie;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public final class Cookies {
    private static final Map<String, BiConsumer<Cookie.Builder, String>> COOKIE_VALUE_HANDLER = new TreeMap<String, BiConsumer<Cookie.Builder, String>>(String.CASE_INSENSITIVE_ORDER);

    private Cookies() {
    }

    public static Cookie parse(@Nonnull String cookieValue) {
        Cookie.Builder builder;
        String value;
        String name;
        int index;
        String nameValuePair;
        if ((cookieValue = cookieValue.trim()).isEmpty()) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(cookieValue, ";");
        try {
            nameValuePair = tokenizer.nextToken();
            index = nameValuePair.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid cookie name-cookieValue pair");
            }
            name = nameValuePair.substring(0, index).trim();
            value = nameValuePair.substring(index + 1).trim();
            builder = Cookie.builder(name).value(value);
        }
        catch (NoSuchElementException ignored) {
            throw new IllegalArgumentException("Empty cookie header string");
        }
        while (tokenizer.hasMoreTokens()) {
            BiConsumer<Cookie.Builder, String> consumer;
            nameValuePair = tokenizer.nextToken();
            index = nameValuePair.indexOf(61);
            if (index != -1) {
                name = nameValuePair.substring(0, index).trim();
                value = nameValuePair.substring(index + 1).trim();
            } else {
                name = nameValuePair.trim();
                value = null;
            }
            if ((consumer = COOKIE_VALUE_HANDLER.get(name)) == null) continue;
            consumer.accept(builder, value);
        }
        return builder.build();
    }

    static {
        COOKIE_VALUE_HANDLER.put("domain", Cookie.Builder::domain);
        COOKIE_VALUE_HANDLER.put("path", Cookie.Builder::path);
        COOKIE_VALUE_HANDLER.put("max-age", (builder, value) -> {
            if (value != null && !value.isEmpty()) {
                builder.maxAge(Long.parseLong(value));
            }
        });
        COOKIE_VALUE_HANDLER.put("secure", (builder, value) -> builder.isSecure(true));
        COOKIE_VALUE_HANDLER.put("httponly", (builder, value) -> builder.isHttpOnly(true));
        COOKIE_VALUE_HANDLER.put("samesite", (builder, value) -> builder.sameSite(Cookie.SameSite.of(value)));
        COOKIE_VALUE_HANDLER.put("same-site", (builder, value) -> builder.sameSite(Cookie.SameSite.of(value)));
        COOKIE_VALUE_HANDLER.put("version", (builder, value) -> {
            try {
                if (value != null && !value.isEmpty()) {
                    builder.version(Integer.parseInt(value));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        COOKIE_VALUE_HANDLER.put("expires", (builder, value) -> {
            if (value != null && !value.isEmpty()) {
                try {
                    builder.expires(DateTimeFactories.parse(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

