/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.Cookie;
import cn.maarlakes.common.http.DefaultCookie;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.Objects;

final class CookieBuilder
implements Cookie.Builder {
    private String name;
    private String value;
    private String domain;
    private String path;
    private long maxAge;
    private boolean isSecure;
    private boolean isHttpOnly;
    private Cookie.SameSite sameSite;
    private Integer version;
    private LocalDateTime expires;

    CookieBuilder() {
    }

    CookieBuilder(String name) {
        this.name(name);
    }

    Cookie.Builder name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("name");
        }
        this.name = name;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder value(@Nonnull String value) {
        this.value = Objects.requireNonNull(value);
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder maxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder isSecure(boolean isSecure) {
        this.isSecure = isSecure;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder isHttpOnly(boolean isHttpOnly) {
        this.isHttpOnly = isHttpOnly;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder sameSite(Cookie.SameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder version(Integer version) {
        this.version = version;
        return this;
    }

    @Override
    @Nonnull
    public Cookie.Builder expires(LocalDateTime expires) {
        this.expires = expires;
        return this;
    }

    @Override
    @Nonnull
    public Cookie build() {
        return new DefaultCookie(this.name, this.value, this.domain, this.path, this.maxAge, this.isSecure, this.isHttpOnly, this.sameSite, this.version, this.expires);
    }
}

