/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.CookieBuilder;
import cn.maarlakes.common.http.Cookies;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.LocalDateTime;

public interface Cookie
extends Comparable<Cookie>,
Serializable {
    @Nonnull
    public String name();

    public String value();

    public String domain();

    public String path();

    public long maxAge();

    public boolean isSecure();

    public boolean isHttpOnly();

    public SameSite sameSite();

    public Integer version();

    public LocalDateTime expires();

    @Nonnull
    public static Builder builder(@Nonnull String name) {
        return new CookieBuilder(name);
    }

    public static Cookie parse(@Nonnull String value) {
        return Cookies.parse(value);
    }

    public static enum SameSite {
        Lax,
        Strict,
        None;


        public static SameSite of(@Nonnull String value) {
            for (SameSite sameSite : SameSite.values()) {
                if (!sameSite.name().equalsIgnoreCase(value)) continue;
                return sameSite;
            }
            return null;
        }
    }

    public static interface Builder {
        @Nonnull
        public Builder value(@Nonnull String var1);

        @Nonnull
        public Builder domain(String var1);

        @Nonnull
        public Builder path(String var1);

        @Nonnull
        public Builder maxAge(long var1);

        @Nonnull
        public Builder isSecure(boolean var1);

        @Nonnull
        public Builder isHttpOnly(boolean var1);

        @Nonnull
        public Builder sameSite(SameSite var1);

        @Nonnull
        default public Builder sameSite(String sameSite) {
            if (sameSite == null) {
                return this.sameSite((SameSite)null);
            }
            return this.sameSite(SameSite.of(sameSite));
        }

        @Nonnull
        public Builder version(Integer var1);

        @Nonnull
        public Builder expires(LocalDateTime var1);

        @Nonnull
        public Cookie build();
    }
}

