/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.ContentTypes;
import cn.maarlakes.common.http.DefaultContentType;
import cn.maarlakes.common.http.DefaultHeader;
import cn.maarlakes.common.http.DefaultNameValuePair;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.NameValuePair;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public interface ContentType
extends Serializable {
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream");
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.UTF_8);
    public static final ContentType IMAGE_GIF = ContentType.create("image/gif");
    public static final ContentType IMAGE_JPEG = ContentType.create("image/jpeg");
    public static final ContentType IMAGE_PNG = ContentType.create("image/png");
    public static final ContentType IMAGE_TIFF = ContentType.create("image/tiff");
    public static final ContentType IMAGE_WEBP = ContentType.create("image/webp");
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.UTF_8);
    public static final ContentType TEXT_EVENT_STREAM = ContentType.create("text/event-stream", StandardCharsets.UTF_8);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.UTF_8);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.UTF_8);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.UTF_8);
    public static final ContentType ALL = ContentType.create("*/*");

    @Nonnull
    public String getMediaType();

    public String getCharset();

    public Collection<NameValuePair> getParameters();

    public String getParameter(@Nonnull String var1);

    @Nonnull
    default public ContentType withCharset(Charset charset) {
        if (charset == null) {
            return this.withCharset((String)null);
        }
        return this.withCharset(charset.name());
    }

    @Nonnull
    public ContentType withCharset(String var1);

    @Nonnull
    default public ContentType withParameter(@Nonnull String name, @Nonnull String value) {
        return this.withParameter(new DefaultNameValuePair(name, value));
    }

    @Nonnull
    public ContentType withParameter(NameValuePair ... var1);

    @Nonnull
    default public Header toHeader() {
        return new DefaultHeader("content-type", ContentTypes.toString(this));
    }

    @Nonnull
    public static ContentType create(@Nonnull String mediaType) {
        return new DefaultContentType(mediaType, null, Collections.emptyList());
    }

    @Nonnull
    public static ContentType create(@Nonnull String mediaType, Charset charset) {
        return ContentType.create(mediaType, charset, Collections.emptyList());
    }

    @Nonnull
    public static ContentType create(@Nonnull String mediaType, Charset charset, Collection<? extends NameValuePair> parameters) {
        return new DefaultContentType(mediaType, charset == null ? null : charset.name().toLowerCase(), parameters == null ? Collections.emptyList() : parameters);
    }

    @Nonnull
    public static ContentType create(@Nonnull String mediaType, Collection<? extends NameValuePair> parameters) {
        return new DefaultContentType(mediaType, null, parameters == null ? Collections.emptyList() : parameters);
    }

    @Nonnull
    public static ContentType create(@Nonnull String mediaType, String charset) {
        return ContentType.create(mediaType, charset, Collections.emptyList());
    }

    @Nonnull
    public static ContentType create(@Nonnull String mediaType, String charset, Collection<? extends NameValuePair> parameters) {
        return new DefaultContentType(mediaType, charset, parameters == null ? Collections.emptyList() : parameters);
    }

    public static ContentType parse(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        int endIndex = value.indexOf(";");
        if (endIndex < 0) {
            return ContentType.create(value);
        }
        String mediaType = value.substring(0, endIndex).trim();
        if ((value = value.substring(endIndex + 1).trim()).isEmpty()) {
            return ContentType.create(mediaType);
        }
        ArrayList<DefaultNameValuePair> params = new ArrayList<DefaultNameValuePair>();
        String charset = null;
        for (String item : value.split(";")) {
            String[] tmp = item.split("=");
            if (tmp.length != 2) continue;
            String name = tmp[0].trim();
            if ("charset".equalsIgnoreCase(name)) {
                charset = tmp[1].trim();
                continue;
            }
            params.add(new DefaultNameValuePair(name, tmp[1].trim()));
        }
        return ContentType.create(mediaType, charset, params);
    }
}

