/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.http;

import cn.maarlakes.common.http.ContentType;
import cn.maarlakes.common.http.Header;
import cn.maarlakes.common.http.ResponseBody;
import cn.maarlakes.common.http.encoder.ResponseBodyEncoder;
import cn.maarlakes.common.spi.SpiServiceLoader;
import cn.maarlakes.common.utils.Lazy;
import cn.maarlakes.common.utils.StreamUtils;
import com.alibaba.fastjson2.JSON;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.StreamSupport;

public class ByteArrayResponseBody
implements ResponseBody {
    private static final Lazy<ResponseBodyEncoder[]> DEFAULT_ENCODERS = Lazy.of(() -> (ResponseBodyEncoder[])SpiServiceLoader.loadShared(ResponseBodyEncoder.class, ResponseBodyEncoder.class.getClassLoader()).stream().toArray(ResponseBodyEncoder[]::new));
    private final byte[] content;
    private final ContentType contentType;
    private final Header contentEncoding;
    private final Lazy<ResponseBodyEncoder[]> encoders;

    public ByteArrayResponseBody(@Nonnull byte[] content, ContentType contentType, Header contentEncoding) {
        this(content, contentType, contentEncoding, DEFAULT_ENCODERS);
    }

    public ByteArrayResponseBody(@Nonnull byte[] content, ContentType contentType, Header contentEncoding, ResponseBodyEncoder ... encoders) {
        this(content, contentType, contentEncoding, Lazy.of(() -> encoders));
    }

    public ByteArrayResponseBody(@Nonnull byte[] content, ContentType contentType, Header contentEncoding, Iterable<ResponseBodyEncoder> encoders) {
        this(content, contentType, contentEncoding, Lazy.of(() -> (ResponseBodyEncoder[])StreamSupport.stream(encoders.spliterator(), false).toArray(ResponseBodyEncoder[]::new)));
    }

    private ByteArrayResponseBody(@Nonnull byte[] content, ContentType contentType, Header contentEncoding, Lazy<ResponseBodyEncoder[]> encoders) {
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.encoders = encoders;
    }

    @Override
    @Nonnull
    public InputStream getContent() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.content);
        if (this.contentEncoding != null) {
            for (ResponseBodyEncoder encoder : (ResponseBodyEncoder[])this.encoders.get()) {
                if (!encoder.supported(this.contentEncoding)) continue;
                return encoder.decoding(inputStream);
            }
        }
        return inputStream;
    }

    @Override
    @Nonnull
    public InputStream getOriginalContent() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public String asText(@Nonnull Charset charset) {
        return new String(this.contentUnzip(), charset);
    }

    @Override
    public byte[] asBytes() {
        return Arrays.copyOf(this.contentUnzip(), this.content.length);
    }

    @Override
    public <T> T toJsonObject(@Nonnull Class<T> type, @Nonnull Charset charset) {
        return (T)JSON.parseObject((byte[])this.contentUnzip(), (int)0, (int)this.content.length, (Charset)charset, type);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArrayResponseBody)) {
            return false;
        }
        ByteArrayResponseBody that = (ByteArrayResponseBody)o;
        return Arrays.equals(this.content, that.content) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.content);
        result = 31 * result + Objects.hashCode(this.contentType);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] contentUnzip() {
        if (this.contentEncoding == null) return this.content;
        try (InputStream inputStream = this.getContent();){
            ResponseBodyEncoder[] responseBodyEncoderArray = (ResponseBodyEncoder[])this.encoders.get();
            int n = responseBodyEncoderArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResponseBodyEncoder encoder = responseBodyEncoderArray[n2];
                if (encoder.supported(this.contentEncoding)) {
                    byte[] byArray = StreamUtils.readAllBytes(encoder.decoding(inputStream));
                    return byArray;
                }
                ++n2;
            }
            return this.content;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

