/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.function;

import cn.maarlakes.common.function.Function0;
import cn.maarlakes.common.function.Functions;
import jakarta.annotation.Nonnull;
import java.util.function.Consumer;
import java.util.function.Function;

@FunctionalInterface
public interface Function1<T1, R>
extends Function<T1, R> {
    @Override
    default public R apply(T1 t1) {
        return this.applyUnchecked(t1);
    }

    default public R applyUnchecked(T1 t1) {
        return this.applyUnchecked(t1, Functions.THROWABLE_TO_RUNTIME_EXCEPTION);
    }

    default public R applyUnchecked(T1 t1, @Nonnull Consumer<Throwable> handler) {
        try {
            return this.apply0(t1);
        }
        catch (Throwable throwable) {
            handler.accept(throwable);
            throw new IllegalStateException(throwable);
        }
    }

    default public R applyUnchecked(T1 t1, @Nonnull Function<Throwable, R> handler) {
        try {
            return this.apply0(t1);
        }
        catch (Throwable throwable) {
            return handler.apply(throwable);
        }
    }

    public R apply0(T1 var1) throws Exception;

    @Nonnull
    default public Function0<R> acceptPartially(T1 t1) {
        return () -> this.apply0(t1);
    }

    @Nonnull
    default public Function<T1, R> toFunction() {
        return this::applyUnchecked;
    }

    @Nonnull
    public static <T1, R> Function1<T1, R> from(@Nonnull Function<T1, R> function) {
        return function::apply;
    }

    public static <T> Function1<T, T> identity() {
        return t -> t;
    }
}

