/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.factory.json;

import cn.maarlakes.common.factory.json.JsonProvider;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FastjsonProvider
implements JsonProvider {
    private FastjsonProvider() {
    }

    @Nonnull
    public static FastjsonProvider getInstance() {
        return Helper.PROVIDER;
    }

    @Override
    @Nonnull
    public <T> String toJson(@Nonnull T value) {
        return JSON.toJSONString(value);
    }

    @Override
    @Nonnull
    public <T> T toModel(@Nonnull CharSequence json, @Nonnull Class<T> type) {
        return (T)JSON.parseObject((String)json.toString(), type);
    }

    @Override
    @Nonnull
    public <T> List<T> toList(@Nonnull CharSequence json, @Nonnull Class<T> type) {
        return JSON.parseArray((String)json.toString(), type);
    }

    @Override
    @Nonnull
    public <T> Set<T> toSet(@Nonnull CharSequence json, @Nonnull Class<T> type) {
        return (Set)JSON.parseObject((String)json.toString(), (TypeReference)new TypeReference<Set<T>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull CharSequence json, @Nonnull Class<T> type) {
        return JSON.parseArray((String)json.toString()).toArray(type, new JSONReader.Feature[0]);
    }

    @Override
    @Nonnull
    public <K, V> Map<K, V> toMap(@Nonnull CharSequence json, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        return (Map)JSON.parseObject((String)json.toString(), (TypeReference)new TypeReference<Map<K, V>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    private static final class Helper {
        static final FastjsonProvider PROVIDER = new FastjsonProvider();

        private Helper() {
        }
    }
}

