/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.factory.datetime;

import cn.maarlakes.common.factory.datetime.DateTimeFactories;
import cn.maarlakes.common.factory.datetime.DateTimeParser;
import cn.maarlakes.common.spi.SpiService;
import jakarta.annotation.Nonnull;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.regex.Pattern;

@SpiService(lifecycle=SpiService.Lifecycle.SINGLETON)
public class TimestampDateTimeParser
implements DateTimeParser {
    protected static final Pattern DATE_TO_MINUTES_PATTERN = Pattern.compile("^\\d{4}((0[1-9])|(1[0-2]))((0[1-9])|([1-2][0-9])|(3[0-1]))(([0-1][0-9])|(2[0-3]))(([0-5][0-9])|60)$");
    protected static final Pattern DATE_TO_SECOND_PATTERN = Pattern.compile("^\\d{4}((0[1-9])|(1[0-2]))((0[1-9])|([1-2][0-9])|(3[0-1]))(([0-1][0-9])|(2[0-3]))(([0-5][0-9])|60)(([0-5][0-9])|60)$");
    protected static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^\\d+$");

    @Override
    public boolean supported(@Nonnull String datetime, @Nonnull Class<? extends TemporalAccessor> timeType, @Nonnull Locale locale) {
        return TIMESTAMP_PATTERN.matcher(datetime).matches();
    }

    @Override
    @Nonnull
    public TemporalAccessor parse(@Nonnull String datetime, @Nonnull Locale locale) {
        return DateTimeFactories.fromEpochMilli(Long.parseUnsignedLong(datetime));
    }
}

