/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.factory.datetime;

import cn.maarlakes.common.Ordered;
import cn.maarlakes.common.OrderedComparator;
import cn.maarlakes.common.factory.datetime.DateTimeParser;
import cn.maarlakes.common.spi.SpiServiceLoader;
import cn.maarlakes.common.utils.Comparators;
import cn.maarlakes.common.utils.Lazy;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class DateTimeFactories {
    private static final Supplier<List<ParserWrapper>> PARSER = Lazy.of(() -> StreamSupport.stream(SpiServiceLoader.loadShared(DateTimeParser.class, DateTimeParser.class.getClassLoader()).spliterator(), false).map(ParserWrapper::new).collect(Collectors.toList()));
    private static final Comparator<Object> COMPARATOR = OrderedComparator.getInstance().reversed();
    public static final ZoneOffset LOCAL_OFFSET = ZoneOffset.systemDefault().getRules().getOffset(LocalDateTime.now());
    public static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral(':').optionalEnd().appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendLiteral(':').optionalEnd().optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().optionalStart().appendOffsetId().toFormatter();
    public static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().optionalStart().appendValueReduced((TemporalField)ChronoField.YEAR_OF_ERA, 2, 4, LocalDate.of(2000, 1, 1)).optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('\u5e74').optionalEnd().appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('\u6708').optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NORMAL).optionalStart().appendLiteral('\u65e5').optionalEnd().toFormatter();
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DATE_FORMATTER).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().optionalStart().append(TIME_FORMATTER).optionalEnd().toFormatter();

    private DateTimeFactories() {
    }

    @Nonnull
    public static LocalDateTime parse(@Nonnull String datetime) {
        return DateTimeFactories.parse(datetime, Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnull
    public static LocalDateTime parse(@Nonnull String datetime, @Nonnull Locale locale) {
        String newDatetime = datetime.trim();
        return PARSER.get().stream().sorted(COMPARATOR).filter(item -> ((ParserWrapper)item).parser.supported(newDatetime, LocalDateTime.class, locale)).findFirst().map(item -> {
            LocalDateTime time = DateTimeFactories.toLocalDateTime(((ParserWrapper)item).parser.parse(newDatetime, locale));
            ((ParserWrapper)item).counter.incrementAndGet();
            return time;
        }).orElseGet(() -> LocalDateTime.parse(newDatetime, DATE_TIME_FORMATTER.withLocale(locale)));
    }

    @Nonnull
    @SafeVarargs
    public static <T extends ChronoLocalDateTime<?>> T min(@Nonnull T first, T ... others) {
        ChronoLocalDateTime min = (ChronoLocalDateTime)Comparators.min(others);
        if (min != null && first.compareTo(min) > 0) {
            return (T)min;
        }
        return first;
    }

    @Nonnull
    @SafeVarargs
    public static <T extends ChronoLocalDateTime<?>> T max(@Nonnull T first, T ... others) {
        ChronoLocalDateTime max = (ChronoLocalDateTime)Comparators.max(others);
        if (max != null && first.compareTo(max) < 0) {
            return (T)max;
        }
        return first;
    }

    @Nonnull
    @SafeVarargs
    public static <T extends ChronoLocalDate> T min(@Nonnull T first, T ... others) {
        ChronoLocalDate min = (ChronoLocalDate)Comparators.min(others);
        if (min != null && first.compareTo(min) > 0) {
            return (T)min;
        }
        return first;
    }

    @Nonnull
    @SafeVarargs
    public static <T extends ChronoLocalDate> T max(@Nonnull T first, T ... others) {
        ChronoLocalDate max = (ChronoLocalDate)Comparators.max(others);
        if (max != null && first.compareTo(max) < 0) {
            return (T)max;
        }
        return first;
    }

    @Nonnull
    @SafeVarargs
    public static <T extends ChronoZonedDateTime<?>> T min(@Nonnull T first, T ... others) {
        ChronoZonedDateTime min = (ChronoZonedDateTime)Comparators.min(others);
        if (min != null && first.compareTo(min) > 0) {
            return (T)min;
        }
        return first;
    }

    @Nonnull
    @SafeVarargs
    public static <T extends ChronoZonedDateTime<?>> T max(@Nonnull T first, T ... others) {
        ChronoZonedDateTime max = (ChronoZonedDateTime)Comparators.max(others);
        if (max != null && first.compareTo(max) < 0) {
            return (T)max;
        }
        return first;
    }

    @Nonnull
    public static LocalTime min(@Nonnull LocalTime first, LocalTime ... others) {
        LocalTime min = (LocalTime)Comparators.min((Comparable[])others);
        if (min != null && first.isAfter(min)) {
            return min;
        }
        return first;
    }

    @Nonnull
    public static LocalTime max(@Nonnull LocalTime first, LocalTime ... others) {
        LocalTime max = (LocalTime)Comparators.max((Comparable[])others);
        if (max != null && first.isBefore(max)) {
            return max;
        }
        return first;
    }

    @Nonnull
    public static Instant min(@Nonnull Instant first, Instant ... others) {
        Instant min = (Instant)Comparators.min((Comparable[])others);
        if (min != null && first.isAfter(min)) {
            return min;
        }
        return first;
    }

    @Nonnull
    public static Instant max(@Nonnull Instant first, Instant ... others) {
        Instant max = (Instant)Comparators.max((Comparable[])others);
        if (max != null && first.isBefore(max)) {
            return max;
        }
        return first;
    }

    @Nonnull
    public static OffsetDateTime min(@Nonnull OffsetDateTime first, OffsetDateTime ... others) {
        OffsetDateTime min = (OffsetDateTime)Comparators.min((Comparable[])others);
        if (min != null && first.isAfter(min)) {
            return min;
        }
        return first;
    }

    @Nonnull
    public static OffsetDateTime max(@Nonnull OffsetDateTime first, OffsetDateTime ... others) {
        OffsetDateTime max = (OffsetDateTime)Comparators.max((Comparable[])others);
        if (max != null && first.isBefore(max)) {
            return max;
        }
        return first;
    }

    @Nonnull
    public static OffsetTime min(@Nonnull OffsetTime first, OffsetTime ... others) {
        OffsetTime min = (OffsetTime)Comparators.min((Comparable[])others);
        if (min != null && first.isAfter(min)) {
            return min;
        }
        return first;
    }

    @Nonnull
    public static OffsetTime max(@Nonnull OffsetTime first, OffsetTime ... others) {
        OffsetTime max = (OffsetTime)Comparators.max((Comparable[])others);
        if (max != null && first.isBefore(max)) {
            return max;
        }
        return first;
    }

    @Nonnull
    public static LocalDateTime parse(@Nonnull String datetime, @Nonnull String pattern) {
        return LocalDateTime.parse(datetime, DateTimeFormatter.ofPattern(pattern));
    }

    @Nonnull
    public static LocalDateTime fromEpochSecond(long epochSecond) {
        return DateTimeFactories.fromEpochSecond(epochSecond, ZoneId.systemDefault());
    }

    @Nonnull
    public static LocalDateTime fromEpochSecond(long epochSecond, @Nonnull ZoneId zone) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSecond), zone);
    }

    @Nonnull
    public static LocalDateTime fromEpochSecond(long epochSecond, long nanoAdjustment) {
        return DateTimeFactories.fromEpochSecond(epochSecond, nanoAdjustment, ZoneId.systemDefault());
    }

    @Nonnull
    public static LocalDateTime fromEpochSecond(long epochSecond, long nanoAdjustment, @Nonnull ZoneId zone) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nanoAdjustment), zone);
    }

    @Nonnull
    public static LocalDateTime fromEpochMilli(long epocMilli) {
        return DateTimeFactories.fromEpochMilli(epocMilli, ZoneId.systemDefault());
    }

    @Nonnull
    public static LocalDateTime fromEpochMilli(long epocMilli, @Nonnull ZoneId zone) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epocMilli), zone);
    }

    public static long toEpochSecond(@Nonnull LocalDateTime dateTime) {
        return DateTimeFactories.toEpochSecond(dateTime, ZoneOffset.systemDefault().getRules().getOffset(dateTime));
    }

    public static long toEpochSecond(@Nonnull LocalDateTime dateTime, @Nonnull ZoneOffset offset) {
        return DateTimeFactories.toEpochMilli(dateTime, offset) / 1000L;
    }

    public static long toEpochMilli(@Nonnull LocalDateTime dateTime) {
        return DateTimeFactories.toEpochMilli(dateTime, ZoneOffset.systemDefault().getRules().getOffset(dateTime));
    }

    public static long toEpochMilli(@Nonnull LocalDateTime dateTime, @Nonnull ZoneOffset offset) {
        return dateTime.toInstant(offset).toEpochMilli();
    }

    private static LocalDateTime toLocalDateTime(@Nonnull TemporalAccessor accessor) {
        if (accessor instanceof LocalDateTime) {
            return (LocalDateTime)accessor;
        }
        if (accessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)accessor).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (accessor instanceof OffsetDateTime) {
            return ((OffsetDateTime)accessor).withOffsetSameInstant(LOCAL_OFFSET).toLocalDateTime();
        }
        if (accessor instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)accessor, LocalTime.MIN);
        }
        if (accessor instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)accessor);
        }
        if (accessor instanceof OffsetTime) {
            return ((OffsetTime)accessor).atDate(LocalDate.now()).withOffsetSameInstant(LOCAL_OFFSET).toLocalDateTime();
        }
        if (accessor instanceof Instant) {
            Instant instant = (Instant)accessor;
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        LocalDateTime localDateTime = DateTimeFactories.toLocalDateTime0(accessor);
        if (accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            return localDateTime.atOffset(ZoneOffset.ofTotalSeconds(accessor.get(ChronoField.OFFSET_SECONDS))).withOffsetSameInstant(LOCAL_OFFSET).toLocalDateTime();
        }
        return localDateTime;
    }

    private static LocalDateTime toLocalDateTime0(@Nonnull TemporalAccessor accessor) {
        LocalDate date = DateTimeFactories.tryToLocalDate(accessor);
        LocalTime time = DateTimeFactories.tryToLocalTime(accessor);
        if (date != null) {
            if (time == null) {
                return LocalDateTime.of(date, LocalTime.MIDNIGHT);
            }
            return LocalDateTime.of(date, time);
        }
        if (time != null) {
            return LocalDateTime.of(LocalDate.now(), time);
        }
        return LocalDateTime.from(accessor);
    }

    private static LocalDate tryToLocalDate(@Nonnull TemporalAccessor accessor) {
        if (accessor instanceof LocalDate) {
            return (LocalDate)accessor;
        }
        if (accessor.isSupported(ChronoField.EPOCH_DAY)) {
            return LocalDate.ofEpochDay(accessor.getLong(ChronoField.EPOCH_DAY));
        }
        if (!accessor.isSupported(ChronoField.YEAR)) {
            if (!accessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return null;
            }
            int month = accessor.get(ChronoField.MONTH_OF_YEAR);
            LocalDate now = LocalDate.now();
            if (!accessor.isSupported(ChronoField.DAY_OF_MONTH)) {
                return LocalDate.of(now.getYear(), month, 1);
            }
            return LocalDate.of(now.getYear(), month, accessor.get(ChronoField.DAY_OF_MONTH));
        }
        if (!accessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
            return LocalDate.of(accessor.get(ChronoField.YEAR), 1, 1);
        }
        if (!accessor.isSupported(ChronoField.DAY_OF_MONTH)) {
            return LocalDate.of(accessor.get(ChronoField.YEAR), accessor.get(ChronoField.MONTH_OF_YEAR), 1);
        }
        return LocalDate.of(accessor.get(ChronoField.YEAR), accessor.get(ChronoField.MONTH_OF_YEAR), accessor.get(ChronoField.DAY_OF_MONTH));
    }

    private static LocalTime tryToLocalTime(@Nonnull TemporalAccessor accessor) {
        if (accessor instanceof LocalTime) {
            return (LocalTime)accessor;
        }
        if (accessor instanceof OffsetTime) {
            return ((OffsetTime)accessor).toLocalTime();
        }
        LocalTime time = accessor.query(TemporalQueries.localTime());
        if (time != null) {
            return time;
        }
        if (accessor.isSupported(ChronoField.SECOND_OF_DAY)) {
            return LocalTime.ofSecondOfDay(accessor.getLong(ChronoField.SECOND_OF_DAY));
        }
        if (!accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
            return null;
        }
        int hour = accessor.get(ChronoField.HOUR_OF_DAY);
        if (!accessor.isSupported(ChronoField.MINUTE_OF_HOUR)) {
            return LocalTime.of(hour, 0);
        }
        int minute = accessor.get(ChronoField.MINUTE_OF_HOUR);
        if (!accessor.isSupported(ChronoField.SECOND_OF_MINUTE)) {
            return LocalTime.of(hour, minute);
        }
        int second = accessor.get(ChronoField.SECOND_OF_MINUTE);
        if (!accessor.isSupported(ChronoField.NANO_OF_SECOND)) {
            return LocalTime.of(hour, minute, second);
        }
        return LocalTime.of(hour, minute, second, accessor.get(ChronoField.NANO_OF_SECOND));
    }

    private static final class ParserWrapper
    implements Ordered {
        private final DateTimeParser parser;
        private final AtomicInteger counter = new AtomicInteger(0);

        public ParserWrapper(DateTimeParser parser) {
            this.parser = parser;
        }

        @Override
        public int order() {
            return this.counter.get();
        }
    }
}

