/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.chain;

import cn.maarlakes.common.tuple.KeyValuePair;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;

public interface ChainContext<H, R> {
    public R result();

    @Nonnull
    public List<KeyValuePair<H, R>> results();

    public boolean addResult(@Nonnull H var1, R var2);

    default public R firstResult() {
        return this.firstResultOptional().orElse(null);
    }

    default public Optional<R> firstResultOptional() {
        return this.firstOptional().map(KeyValuePair::value);
    }

    default public KeyValuePair<H, R> first() {
        return this.firstOptional().orElse(null);
    }

    @Nonnull
    default public Optional<KeyValuePair<H, R>> firstOptional() {
        List<KeyValuePair<H, R>> results = this.results();
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(results.get(0));
    }

    default public R lastResult() {
        return this.lastResultOptional().orElse(null);
    }

    @Nonnull
    default public Optional<R> lastResultOptional() {
        return this.lastOptional().map(KeyValuePair::value);
    }

    default public KeyValuePair<H, R> last() {
        return this.lastOptional().orElse(null);
    }

    @Nonnull
    default public Optional<KeyValuePair<H, R>> lastOptional() {
        List<KeyValuePair<H, R>> results = this.results();
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(results.get(results.size() - 1));
    }
}

