/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.chain;

import cn.maarlakes.common.chain.ChainContext;
import cn.maarlakes.common.chain.ChainFactory;
import cn.maarlakes.common.chain.ContextChainInvocationHandler;
import cn.maarlakes.common.chain.FirstResultChainInvocationHandler;
import cn.maarlakes.common.chain.NoneResultChainInvocationHandler;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;

public abstract class AbstractChainFactory
implements ChainFactory {
    @Override
    @Nonnull
    public <H, R> H createChain(@Nonnull Class<H> type, @Nonnull ChainContext<H, R> context) {
        return (H)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new ContextChainInvocationHandler<H, R>(type, this.createHandlers(type), context));
    }

    @Override
    @Nonnull
    public <H, R> H createReverseChain(@Nonnull Class<H> type, @Nonnull ChainContext<H, R> context) {
        return (H)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new ContextChainInvocationHandler<H, R>(type, this.createReverseHandlers(type), context));
    }

    @Override
    public <H> H createNoneResultChain(@Nonnull Class<H> type) {
        return (H)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new NoneResultChainInvocationHandler<H>(type, this.createHandlers(type)));
    }

    @Override
    public <H> H createFirstResultChain(@Nonnull Class<H> type) {
        return (H)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new FirstResultChainInvocationHandler<H>(type, this.createHandlers(type)));
    }

    @Override
    public <H> H createNoneResultReverseChain(@Nonnull Class<H> type) {
        return (H)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new NoneResultChainInvocationHandler<H>(type, this.createReverseHandlers(type)));
    }

    @Override
    public <H> H createFirstResultReserveChain(@Nonnull Class<H> type) {
        return (H)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new FirstResultChainInvocationHandler<H>(type, this.createReverseHandlers(type)));
    }

    protected abstract <H> H[] createHandlers(@Nonnull Class<H> var1);

    protected <H> H[] createReverseHandlers(@Nonnull Class<H> type) {
        return Arrays.stream(this.createHandlers(type)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            Collections.reverse(list);
            return list.stream();
        })).toArray(length -> (Object[])Array.newInstance(type, length));
    }
}

